package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class AWSElasticBlockStoreVolumeSourceFluentImpl<A extends AWSElasticBlockStoreVolumeSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements AWSElasticBlockStoreVolumeSourceFluent<A>{

    private String fsType;
    private Integer partition;
    private Boolean readOnly;
    private String volumeID;

    public AWSElasticBlockStoreVolumeSourceFluentImpl(){
    }
    public AWSElasticBlockStoreVolumeSourceFluentImpl(AWSElasticBlockStoreVolumeSource instance){
            this.withFsType(instance.getFsType()); 
            this.withPartition(instance.getPartition()); 
            this.withReadOnly(instance.getReadOnly()); 
            this.withVolumeID(instance.getVolumeID()); 
    }

    public String getFsType(){
            return this.fsType;
    }

    public A withFsType(String fsType){
            this.fsType=fsType; return (A) this;
    }

    public Boolean hasFsType(){
            return this.fsType != null;
    }

    public Integer getPartition(){
            return this.partition;
    }

    public A withPartition(Integer partition){
            this.partition=partition; return (A) this;
    }

    public Boolean hasPartition(){
            return this.partition != null;
    }

    public Boolean isReadOnly(){
            return this.readOnly;
    }

    public A withReadOnly(Boolean readOnly){
            this.readOnly=readOnly; return (A) this;
    }

    public Boolean hasReadOnly(){
            return this.readOnly != null;
    }

    public String getVolumeID(){
            return this.volumeID;
    }

    public A withVolumeID(String volumeID){
            this.volumeID=volumeID; return (A) this;
    }

    public Boolean hasVolumeID(){
            return this.volumeID != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            AWSElasticBlockStoreVolumeSourceFluentImpl that = (AWSElasticBlockStoreVolumeSourceFluentImpl) o;
            if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
            if (partition != null ? !partition.equals(that.partition) :that.partition != null) return false;
            if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
            if (volumeID != null ? !volumeID.equals(that.volumeID) :that.volumeID != null) return false;
            return true;
    }




}
