package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NamedRoleBindingFluentImpl<A extends NamedRoleBindingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NamedRoleBindingFluent<A>{

    private String name;
    private RoleBindingBuilder roleBinding;

    public NamedRoleBindingFluentImpl(){
    }
    public NamedRoleBindingFluentImpl(NamedRoleBinding instance){
            this.withName(instance.getName()); 
            this.withRoleBinding(instance.getRoleBinding()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Boolean hasName(){
            return this.name != null;
    }

    
/**
 * This method has been deprecated, please use method buildRoleBinding instead.
 */
@Deprecated public RoleBinding getRoleBinding(){
            return this.roleBinding!=null?this.roleBinding.build():null;
    }

    public RoleBinding buildRoleBinding(){
            return this.roleBinding!=null?this.roleBinding.build():null;
    }

    public A withRoleBinding(RoleBinding roleBinding){
            _visitables.remove(this.roleBinding);
            if (roleBinding!=null){ this.roleBinding= new RoleBindingBuilder(roleBinding); _visitables.add(this.roleBinding);} return (A) this;
    }

    public Boolean hasRoleBinding(){
            return this.roleBinding != null;
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding(){
            return new RoleBindingNestedImpl();
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item){
            return new RoleBindingNestedImpl(item);
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> editRoleBinding(){
            return withNewRoleBindingLike(getRoleBinding());
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBinding(){
            return withNewRoleBindingLike(getRoleBinding() != null ? getRoleBinding(): new RoleBindingBuilder().build());
    }

    public NamedRoleBindingFluent.RoleBindingNested<A> editOrNewRoleBindingLike(RoleBinding item){
            return withNewRoleBindingLike(getRoleBinding() != null ? getRoleBinding(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NamedRoleBindingFluentImpl that = (NamedRoleBindingFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (roleBinding != null ? !roleBinding.equals(that.roleBinding) :that.roleBinding != null) return false;
            return true;
    }


    public class RoleBindingNestedImpl<N> extends RoleBindingFluentImpl<NamedRoleBindingFluent.RoleBindingNested<N>> implements NamedRoleBindingFluent.RoleBindingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final RoleBindingBuilder builder;
    
            RoleBindingNestedImpl(RoleBinding item){
                    this.builder = new RoleBindingBuilder(this, item);
            }
            RoleBindingNestedImpl(){
                    this.builder = new RoleBindingBuilder(this);
            }
    
    public N and(){
            return (N) NamedRoleBindingFluentImpl.this.withRoleBinding(builder.build());
    }
    public N endRoleBinding(){
            return and();
    }

}


}
