package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class PolicyFluentImpl<A extends PolicyFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PolicyFluent<A>{

    private String apiVersion;
    private String kind;
    private String lastModified;
    private ObjectMetaBuilder metadata;
    private List<NamedRoleBuilder> roles =  new ArrayList<NamedRoleBuilder>();

    public PolicyFluentImpl(){
    }
    public PolicyFluentImpl(Policy instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public String getLastModified(){
            return this.lastModified;
    }

    public A withLastModified(String lastModified){
            this.lastModified=lastModified; return (A) this;
    }

    public Boolean hasLastModified(){
            return this.lastModified != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public PolicyFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public PolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public PolicyFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public PolicyFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public PolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToRoles(int index,NamedRole item){
            if (this.roles == null) {this.roles = new ArrayList<NamedRoleBuilder>();}
            NamedRoleBuilder builder = new NamedRoleBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.roles.add(index >= 0 ? index : roles.size(), builder); return (A)this;
    }

    public A setToRoles(int index,NamedRole item){
            if (this.roles == null) {this.roles = new ArrayList<NamedRoleBuilder>();}
            NamedRoleBuilder builder = new NamedRoleBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= roles.size()) { roles.add(builder); } else { roles.set(index, builder);}
             return (A)this;
    }

    public A addToRoles(NamedRole... items){
            if (this.roles == null) {this.roles = new ArrayList<NamedRoleBuilder>();}
            for (NamedRole item : items) {NamedRoleBuilder builder = new NamedRoleBuilder(item);_visitables.add(builder);this.roles.add(builder);} return (A)this;
    }

    public A addAllToRoles(Collection<NamedRole> items){
            if (this.roles == null) {this.roles = new ArrayList<NamedRoleBuilder>();}
            for (NamedRole item : items) {NamedRoleBuilder builder = new NamedRoleBuilder(item);_visitables.add(builder);this.roles.add(builder);} return (A)this;
    }

    public A removeFromRoles(NamedRole... items){
            for (NamedRole item : items) {NamedRoleBuilder builder = new NamedRoleBuilder(item);_visitables.remove(builder);if (this.roles != null) {this.roles.remove(builder);}} return (A)this;
    }

    public A removeAllFromRoles(Collection<NamedRole> items){
            for (NamedRole item : items) {NamedRoleBuilder builder = new NamedRoleBuilder(item);_visitables.remove(builder);if (this.roles != null) {this.roles.remove(builder);}} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildRoles instead.
 */
@Deprecated public List<NamedRole> getRoles(){
            return build(roles);
    }

    public List<NamedRole> buildRoles(){
            return build(roles);
    }

    public NamedRole buildRole(int index){
            return this.roles.get(index).build();
    }

    public NamedRole buildFirstRole(){
            return this.roles.get(0).build();
    }

    public NamedRole buildLastRole(){
            return this.roles.get(roles.size() - 1).build();
    }

    public NamedRole buildMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedRoleBuilder> predicate){
            for (NamedRoleBuilder item: roles) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withRoles(List<NamedRole> roles){
            if (this.roles == null) { this.roles = new ArrayList<NamedRoleBuilder>();} else {_visitables.removeAll(this.roles); this.roles.clear();}
            if (roles != null) {for (NamedRole item : roles){this.addToRoles(item);}} return (A) this;
    }

    public A withRoles(NamedRole... roles){
            this.roles.clear(); if (roles != null) {for (NamedRole item :roles){ this.addToRoles(item);}} return (A) this;
    }

    public Boolean hasRoles(){
            return roles != null && !roles.isEmpty();
    }

    public PolicyFluent.RolesNested<A> addNewRole(){
            return new RolesNestedImpl();
    }

    public PolicyFluent.RolesNested<A> addNewRoleLike(NamedRole item){
            return new RolesNestedImpl(-1, item);
    }

    public PolicyFluent.RolesNested<A> setNewRoleLike(int index,NamedRole item){
            return new RolesNestedImpl(index, item);
    }

    public PolicyFluent.RolesNested<A> editRole(int index){
            if (roles.size() <= index) throw new RuntimeException("Can't edit roles. Index exceeds size.");
            return setNewRoleLike(index, buildRole(index));
    }

    public PolicyFluent.RolesNested<A> editFirstRole(){
            if (roles.size() == 0) throw new RuntimeException("Can't edit first roles. The list is empty.");
            return setNewRoleLike(0, buildRole(0));
    }

    public PolicyFluent.RolesNested<A> editLastRole(){
            int index = roles.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last roles. The list is empty.");
            return setNewRoleLike(index, buildRole(index));
    }

    public PolicyFluent.RolesNested<A> editMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedRoleBuilder> predicate){
            int index = -1;
            for (int i=0;i<roles.size();i++) { 
            if (predicate.apply(roles.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching roles. No match found.");
            return setNewRoleLike(index, buildRole(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyFluentImpl that = (PolicyFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (lastModified != null ? !lastModified.equals(that.lastModified) :that.lastModified != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (roles != null ? !roles.equals(that.roles) :that.roles != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PolicyFluent.MetadataNested<N>> implements PolicyFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) PolicyFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class RolesNestedImpl<N> extends NamedRoleFluentImpl<PolicyFluent.RolesNested<N>> implements PolicyFluent.RolesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NamedRoleBuilder builder;
        private final int index;
    
            RolesNestedImpl(int index,NamedRole item){
                    this.index = index;
                    this.builder = new NamedRoleBuilder(this, item);
            }
            RolesNestedImpl(){
                    this.index = -1;
                    this.builder = new NamedRoleBuilder(this);
            }
    
    public N and(){
            return (N) PolicyFluentImpl.this.setToRoles(index, builder.build());
    }
    public N endRole(){
            return and();
    }

}


}
