package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StatefulSetBuilder extends StatefulSetFluentImpl<StatefulSetBuilder> implements VisitableBuilder<StatefulSet,StatefulSetBuilder>{

    StatefulSetFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetBuilder(){
            this(true);
    }
    public StatefulSetBuilder(Boolean validationEnabled){
            this(new StatefulSet(), validationEnabled);
    }
    public StatefulSetBuilder(StatefulSetFluent<?> fluent){
            this(fluent, true);
    }
    public StatefulSetBuilder(StatefulSetFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StatefulSet(), validationEnabled);
    }
    public StatefulSetBuilder(StatefulSetFluent<?> fluent,StatefulSet instance){
            this(fluent, instance, true);
    }
    public StatefulSetBuilder(StatefulSetFluent<?> fluent,StatefulSet instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatefulSetBuilder(StatefulSet instance){
            this(instance,true);
    }
    public StatefulSetBuilder(StatefulSet instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }

    public StatefulSet build(){
            StatefulSet buildable = new StatefulSet(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatefulSetBuilder that = (StatefulSetBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
