package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;

public class ResourceQuotaBuilder extends ResourceQuotaFluent<ResourceQuotaBuilder> implements VisitableBuilder<ResourceQuota,ResourceQuotaBuilder>{

     ResourceQuotaFluent<?> fluent;
public ResourceQuotaBuilder(){
    this(new ResourceQuota());
}
public ResourceQuotaBuilder( ResourceQuotaFluent<?> fluent ){
    this(fluent, new ResourceQuota());
}
public ResourceQuotaBuilder( ResourceQuotaFluent<?> fluent , ResourceQuota instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withSpec(instance.getSpec()); fluent.withStatus(instance.getStatus()); 
}
public ResourceQuotaBuilder( ResourceQuota instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withSpec(instance.getSpec()); this.withStatus(instance.getStatus()); 
}

public EditableResourceQuota build(){
    EditableResourceQuota buildable = new EditableResourceQuota(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ResourceQuotaBuilder that = (ResourceQuotaBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
    