package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import java.util.Map;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public class OAuthClientFluent<T extends OAuthClientFluent<T>> extends BaseFluent<T> implements Fluent<T>{

     OAuthClient.ApiVersion apiVersion;     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     List<String> redirectURIs = new ArrayList();     Boolean respondWithChallenges;     String secret;     Map<String, Object> additionalProperties = new HashMap();

    public OAuthClient.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( OAuthClient.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNested<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNested<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T addToRedirectURIs( String ...items){
    for (String item : items) {this.redirectURIs.add(item);} return (T)this;
    }
    public T removeFromRedirectURIs( String ...items){
    for (String item : items) {this.redirectURIs.remove(item);} return (T)this;
    }
    public List<String> getRedirectURIs(){
    return this.redirectURIs;
    }
    public T withRedirectURIs( List<String> redirectURIs){
    this.redirectURIs.clear();if (redirectURIs != null) {for (String item : redirectURIs){this.addToRedirectURIs(item);}} return (T) this;
    }
    public T withRedirectURIs( String ...redirectURIs){
    this.redirectURIs.clear(); if (redirectURIs != null) {for (String item :redirectURIs){ this.addToRedirectURIs(item);}} return (T) this;
    }
    public Boolean isRespondWithChallenges(){
    return this.respondWithChallenges;
    }
    public T withRespondWithChallenges( Boolean respondWithChallenges){
    this.respondWithChallenges=respondWithChallenges; return (T) this;
    }
    public String getSecret(){
    return this.secret;
    }
    public T withSecret( String secret){
    this.secret=secret; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
OAuthClientFluent that = (OAuthClientFluent) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (redirectURIs != null ? !redirectURIs.equals(that.redirectURIs) :that.redirectURIs != null) return false;
if (respondWithChallenges != null ? !respondWithChallenges.equals(that.respondWithChallenges) :that.respondWithChallenges != null) return false;
if (secret != null ? !secret.equals(that.secret) :that.secret != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNested (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNested ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N endMetadata(){
            return and();
        }
            public N and(){
            return (N) OAuthClientFluent.this.withMetadata(builder.build());
        }
    
}


}
