package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class BuildStatusOutputToBuilder extends BuildStatusOutputToFluentImpl<BuildStatusOutputToBuilder> implements VisitableBuilder<BuildStatusOutputTo,BuildStatusOutputToBuilder>{

    BuildStatusOutputToFluent<?> fluent;
    Boolean validationEnabled;

    public BuildStatusOutputToBuilder(){
            this(true);
    }
    public BuildStatusOutputToBuilder(Boolean validationEnabled){
            this(new BuildStatusOutputTo(), validationEnabled);
    }
    public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent){
            this(fluent, true);
    }
    public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BuildStatusOutputTo(), validationEnabled);
    }
    public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent,BuildStatusOutputTo instance){
            this(fluent, instance, true);
    }
    public BuildStatusOutputToBuilder(BuildStatusOutputToFluent<?> fluent,BuildStatusOutputTo instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withImageDigest(instance.getImageDigest()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildStatusOutputToBuilder(BuildStatusOutputTo instance){
            this(instance,true);
    }
    public BuildStatusOutputToBuilder(BuildStatusOutputTo instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withImageDigest(instance.getImageDigest()); 
            this.validationEnabled = validationEnabled; 
    }

    public BuildStatusOutputTo build(){
            BuildStatusOutputTo buildable = new BuildStatusOutputTo(fluent.getImageDigest());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildStatusOutputToBuilder that = (BuildStatusOutputToBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
