package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StatefulSetSpecBuilder extends StatefulSetSpecFluentImpl<StatefulSetSpecBuilder> implements VisitableBuilder<StatefulSetSpec,StatefulSetSpecBuilder>{

    StatefulSetSpecFluent<?> fluent;
    Boolean validationEnabled;

    public StatefulSetSpecBuilder(){
            this(true);
    }
    public StatefulSetSpecBuilder(Boolean validationEnabled){
            this(new StatefulSetSpec(), validationEnabled);
    }
    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent){
            this(fluent, true);
    }
    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StatefulSetSpec(), validationEnabled);
    }
    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent,StatefulSetSpec instance){
            this(fluent, instance, true);
    }
    public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent,StatefulSetSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withReplicas(instance.getReplicas()); 
            fluent.withSelector(instance.getSelector()); 
            fluent.withServiceName(instance.getServiceName()); 
            fluent.withTemplate(instance.getTemplate()); 
            fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
            this.validationEnabled = validationEnabled; 
    }
    public StatefulSetSpecBuilder(StatefulSetSpec instance){
            this(instance,true);
    }
    public StatefulSetSpecBuilder(StatefulSetSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withReplicas(instance.getReplicas()); 
            this.withSelector(instance.getSelector()); 
            this.withServiceName(instance.getServiceName()); 
            this.withTemplate(instance.getTemplate()); 
            this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
            this.validationEnabled = validationEnabled; 
    }

    public StatefulSetSpec build(){
            StatefulSetSpec buildable = new StatefulSetSpec(fluent.getReplicas(),fluent.getSelector(),fluent.getServiceName(),fluent.getTemplate(),fluent.getVolumeClaimTemplates());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatefulSetSpecBuilder that = (StatefulSetSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
