
package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.DeploymentRollback;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicy;
import io.fabric8.kubernetes.api.model.extensions.NetworkPolicyList;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.api.model.extensions.Scale;
import io.fabric8.kubernetes.api.model.extensions.StatefulSet;
import io.fabric8.kubernetes.api.model.extensions.StatefulSetList;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList;
import io.fabric8.openshift.api.model.BuildConfigList;
import io.fabric8.openshift.api.model.BuildList;
import io.fabric8.openshift.api.model.BuildRequest;
import io.fabric8.openshift.api.model.ClusterPolicy;
import io.fabric8.openshift.api.model.ClusterPolicyBinding;
import io.fabric8.openshift.api.model.ClusterPolicyBindingList;
import io.fabric8.openshift.api.model.ClusterPolicyList;
import io.fabric8.openshift.api.model.ClusterRoleBinding;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.DeploymentConfigList;
import io.fabric8.openshift.api.model.Group;
import io.fabric8.openshift.api.model.GroupList;
import io.fabric8.openshift.api.model.Identity;
import io.fabric8.openshift.api.model.IdentityList;
import io.fabric8.openshift.api.model.ImageList;
import io.fabric8.openshift.api.model.ImageStreamList;
import io.fabric8.openshift.api.model.ImageStreamTagList;
import io.fabric8.openshift.api.model.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.OAuthAccessToken;
import io.fabric8.openshift.api.model.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.OAuthClient;
import io.fabric8.openshift.api.model.OAuthClientAuthorization;
import io.fabric8.openshift.api.model.OAuthClientAuthorizationList;
import io.fabric8.openshift.api.model.OAuthClientList;
import io.fabric8.openshift.api.model.Policy;
import io.fabric8.openshift.api.model.PolicyBinding;
import io.fabric8.openshift.api.model.PolicyBindingList;
import io.fabric8.openshift.api.model.PolicyList;
import io.fabric8.openshift.api.model.Project;
import io.fabric8.openshift.api.model.ProjectList;
import io.fabric8.openshift.api.model.ProjectRequest;
import io.fabric8.openshift.api.model.Role;
import io.fabric8.openshift.api.model.RoleBinding;
import io.fabric8.openshift.api.model.RoleBindingList;
import io.fabric8.openshift.api.model.RoleBindingRestriction;
import io.fabric8.openshift.api.model.RoleList;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.api.model.SubjectAccessReview;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.Template;
import io.fabric8.openshift.api.model.TemplateList;
import io.fabric8.openshift.api.model.User;
import io.fabric8.openshift.api.model.UserList;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;

@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "BaseKubernetesList",
    "Binding",
    "BuildConfigList",
    "BuildList",
    "BuildRequest",
    "ClusterPolicy",
    "ClusterPolicyBinding",
    "ClusterPolicyBindingList",
    "ClusterPolicyList",
    "ClusterRoleBinding",
    "ClusterRoleBindingList",
    "ComponentStatusList",
    "Config",
    "ConfigMap",
    "ConfigMapList",
    "ContainerStatus",
    "CronJob",
    "CronJobList",
    "DaemonSet",
    "DaemonSetList",
    "DeleteOptions",
    "Deployment",
    "DeploymentConfigList",
    "DeploymentList",
    "DeploymentRollback",
    "Endpoints",
    "EndpointsList",
    "EnvVar",
    "EventList",
    "Group",
    "GroupList",
    "HorizontalPodAutoscaler",
    "HorizontalPodAutoscalerList",
    "Identity",
    "IdentityList",
    "ImageList",
    "ImageStreamList",
    "ImageStreamTagList",
    "Ingress",
    "IngressList",
    "Job",
    "JobList",
    "LimitRangeList",
    "ListMeta",
    "LocalSubjectAccessReview",
    "Namespace",
    "NamespaceList",
    "Node",
    "NodeList",
    "OAuthAccessToken",
    "OAuthAccessTokenList",
    "OAuthAuthorizeToken",
    "OAuthAuthorizeTokenList",
    "OAuthClient",
    "OAuthClientAuthorization",
    "OAuthClientAuthorizationList",
    "OAuthClientList",
    "ObjectMeta",
    "Patch",
    "PersistentVolume",
    "PersistentVolumeClaim",
    "PersistentVolumeClaimList",
    "PersistentVolumeList",
    "PodList",
    "PodTemplateList",
    "Policy",
    "PolicyBinding",
    "PolicyBindingList",
    "PolicyList",
    "Project",
    "ProjectList",
    "ProjectRequest",
    "Quantity",
    "ReplicaSet",
    "ReplicaSetList",
    "NetworkPolicy",
    "NetworkPolicyList",
    "ReplicationControllerList",
    "ResourceQuota",
    "ResourceQuotaList",
    "Role",
    "RoleBinding",
    "RoleBindingList",
    "RoleBindingRestriction",
    "RoleList",
    "RootPaths",
    "RouteList",
    "Scale",
    "Secret",
    "SecretList",
    "SecurityContextConstraints",
    "SecurityContextConstraintsList",
    "ServiceAccount",
    "ServiceAccountList",
    "ServiceList",
    "StatefulSet",
    "StatefulSetList",
    "Status",
    "SubjectAccessReview",
    "SubjectAccessReviewResponse",
    "TagEvent",
    "Template",
    "TemplateList",
    "ThirdPartyResource",
    "ThirdPartyResourceList",
    "User",
    "UserList",
    "WatchEvent"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class KubeSchema {

    /**
     * 
     * 
     */
    @JsonProperty("BaseKubernetesList")
    @Valid
    private BaseKubernetesList baseKubernetesList;
    /**
     * 
     * 
     */
    @JsonProperty("Binding")
    @Valid
    private Binding binding;
    /**
     * 
     * 
     */
    @JsonProperty("BuildConfigList")
    @Valid
    private BuildConfigList buildConfigList;
    /**
     * 
     * 
     */
    @JsonProperty("BuildList")
    @Valid
    private BuildList buildList;
    /**
     * 
     * 
     */
    @JsonProperty("BuildRequest")
    @Valid
    private BuildRequest buildRequest;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicy")
    @Valid
    private ClusterPolicy clusterPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicyBinding")
    @Valid
    private ClusterPolicyBinding clusterPolicyBinding;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicyBindingList")
    @Valid
    private ClusterPolicyBindingList clusterPolicyBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterPolicyList")
    @Valid
    private ClusterPolicyList clusterPolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRoleBinding")
    @Valid
    private ClusterRoleBinding clusterRoleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("ClusterRoleBindingList")
    @Valid
    private ClusterRoleBindingList clusterRoleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("ComponentStatusList")
    @Valid
    private ComponentStatusList componentStatusList;
    /**
     * 
     * 
     */
    @JsonProperty("Config")
    @Valid
    private Config config;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMap")
    @Valid
    private ConfigMap configMap;
    /**
     * 
     * 
     */
    @JsonProperty("ConfigMapList")
    @Valid
    private ConfigMapList configMapList;
    /**
     * 
     * 
     */
    @JsonProperty("ContainerStatus")
    @Valid
    private ContainerStatus containerStatus;
    /**
     * 
     * 
     */
    @JsonProperty("CronJob")
    @Valid
    private CronJob cronJob;
    /**
     * 
     * 
     */
    @JsonProperty("CronJobList")
    @Valid
    private CronJobList cronJobList;
    /**
     * 
     * 
     */
    @JsonProperty("DaemonSet")
    @Valid
    private DaemonSet daemonSet;
    /**
     * 
     * 
     */
    @JsonProperty("DaemonSetList")
    @Valid
    private DaemonSetList daemonSetList;
    /**
     * 
     * 
     */
    @JsonProperty("DeleteOptions")
    @Valid
    private DeleteOptions deleteOptions;
    /**
     * 
     * 
     */
    @JsonProperty("Deployment")
    @Valid
    private Deployment deployment;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentConfigList")
    @Valid
    private DeploymentConfigList deploymentConfigList;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentList")
    @Valid
    private DeploymentList deploymentList;
    /**
     * 
     * 
     */
    @JsonProperty("DeploymentRollback")
    @Valid
    private DeploymentRollback deploymentRollback;
    /**
     * 
     * 
     */
    @JsonProperty("Endpoints")
    @Valid
    private Endpoints endpoints;
    /**
     * 
     * 
     */
    @JsonProperty("EndpointsList")
    @Valid
    private EndpointsList endpointsList;
    /**
     * 
     * 
     */
    @JsonProperty("EnvVar")
    @Valid
    private EnvVar envVar;
    /**
     * 
     * 
     */
    @JsonProperty("EventList")
    @Valid
    private EventList eventList;
    /**
     * 
     * 
     */
    @JsonProperty("Group")
    @Valid
    private Group group;
    /**
     * 
     * 
     */
    @JsonProperty("GroupList")
    @Valid
    private GroupList groupList;
    /**
     * 
     * 
     */
    @JsonProperty("HorizontalPodAutoscaler")
    @Valid
    private HorizontalPodAutoscaler horizontalPodAutoscaler;
    /**
     * 
     * 
     */
    @JsonProperty("HorizontalPodAutoscalerList")
    @Valid
    private HorizontalPodAutoscalerList horizontalPodAutoscalerList;
    /**
     * 
     * 
     */
    @JsonProperty("Identity")
    @Valid
    private Identity identity;
    /**
     * 
     * 
     */
    @JsonProperty("IdentityList")
    @Valid
    private IdentityList identityList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageList")
    @Valid
    private ImageList imageList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamList")
    @Valid
    private ImageStreamList imageStreamList;
    /**
     * 
     * 
     */
    @JsonProperty("ImageStreamTagList")
    @Valid
    private ImageStreamTagList imageStreamTagList;
    /**
     * 
     * 
     */
    @JsonProperty("Ingress")
    @Valid
    private Ingress ingress;
    /**
     * 
     * 
     */
    @JsonProperty("IngressList")
    @Valid
    private IngressList ingressList;
    /**
     * 
     * 
     */
    @JsonProperty("Job")
    @Valid
    private Job job;
    /**
     * 
     * 
     */
    @JsonProperty("JobList")
    @Valid
    private JobList jobList;
    /**
     * 
     * 
     */
    @JsonProperty("LimitRangeList")
    @Valid
    private LimitRangeList limitRangeList;
    /**
     * 
     * 
     */
    @JsonProperty("ListMeta")
    @Valid
    private ListMeta listMeta;
    /**
     * 
     * 
     */
    @JsonProperty("LocalSubjectAccessReview")
    @Valid
    private LocalSubjectAccessReview localSubjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("Namespace")
    @Valid
    private Namespace namespace;
    /**
     * 
     * 
     */
    @JsonProperty("NamespaceList")
    @Valid
    private NamespaceList namespaceList;
    /**
     * 
     * 
     */
    @JsonProperty("Node")
    @Valid
    private Node node;
    /**
     * 
     * 
     */
    @JsonProperty("NodeList")
    @Valid
    private NodeList nodeList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAccessToken")
    @Valid
    private OAuthAccessToken oAuthAccessToken;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAccessTokenList")
    @Valid
    private OAuthAccessTokenList oAuthAccessTokenList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAuthorizeToken")
    @Valid
    private OAuthAuthorizeToken oAuthAuthorizeToken;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    @Valid
    private OAuthAuthorizeTokenList oAuthAuthorizeTokenList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClient")
    @Valid
    private OAuthClient oAuthClient;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientAuthorization")
    @Valid
    private OAuthClientAuthorization oAuthClientAuthorization;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientAuthorizationList")
    @Valid
    private OAuthClientAuthorizationList oAuthClientAuthorizationList;
    /**
     * 
     * 
     */
    @JsonProperty("OAuthClientList")
    @Valid
    private OAuthClientList oAuthClientList;
    /**
     * 
     * 
     */
    @JsonProperty("ObjectMeta")
    @Valid
    private ObjectMeta objectMeta;
    /**
     * 
     * 
     */
    @JsonProperty("Patch")
    @Valid
    private Patch patch;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolume")
    @Valid
    private PersistentVolume persistentVolume;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeClaim")
    @Valid
    private PersistentVolumeClaim persistentVolumeClaim;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeClaimList")
    @Valid
    private PersistentVolumeClaimList persistentVolumeClaimList;
    /**
     * 
     * 
     */
    @JsonProperty("PersistentVolumeList")
    @Valid
    private PersistentVolumeList persistentVolumeList;
    /**
     * 
     * 
     */
    @JsonProperty("PodList")
    @Valid
    private PodList podList;
    /**
     * 
     * 
     */
    @JsonProperty("PodTemplateList")
    @Valid
    private PodTemplateList podTemplateList;
    /**
     * 
     * 
     */
    @JsonProperty("Policy")
    @Valid
    private Policy policy;
    /**
     * 
     * 
     */
    @JsonProperty("PolicyBinding")
    @Valid
    private PolicyBinding policyBinding;
    /**
     * 
     * 
     */
    @JsonProperty("PolicyBindingList")
    @Valid
    private PolicyBindingList policyBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("PolicyList")
    @Valid
    private PolicyList policyList;
    /**
     * 
     * 
     */
    @JsonProperty("Project")
    @Valid
    private Project project;
    /**
     * 
     * 
     */
    @JsonProperty("ProjectList")
    @Valid
    private ProjectList projectList;
    /**
     * 
     * 
     */
    @JsonProperty("ProjectRequest")
    @Valid
    private ProjectRequest projectRequest;
    /**
     * 
     * 
     */
    @JsonProperty("Quantity")
    @Valid
    private Quantity quantity;
    /**
     * 
     * 
     */
    @JsonProperty("ReplicaSet")
    @Valid
    private ReplicaSet replicaSet;
    /**
     * 
     * 
     */
    @JsonProperty("ReplicaSetList")
    @Valid
    private ReplicaSetList replicaSetList;
    /**
     * 
     * 
     */
    @JsonProperty("NetworkPolicy")
    @Valid
    private NetworkPolicy networkPolicy;
    /**
     * 
     * 
     */
    @JsonProperty("NetworkPolicyList")
    @Valid
    private NetworkPolicyList networkPolicyList;
    /**
     * 
     * 
     */
    @JsonProperty("ReplicationControllerList")
    @Valid
    private ReplicationControllerList replicationControllerList;
    /**
     * 
     * 
     */
    @JsonProperty("ResourceQuota")
    @Valid
    private ResourceQuota resourceQuota;
    /**
     * 
     * 
     */
    @JsonProperty("ResourceQuotaList")
    @Valid
    private ResourceQuotaList resourceQuotaList;
    /**
     * 
     * 
     */
    @JsonProperty("Role")
    @Valid
    private Role role;
    /**
     * 
     * 
     */
    @JsonProperty("RoleBinding")
    @Valid
    private RoleBinding roleBinding;
    /**
     * 
     * 
     */
    @JsonProperty("RoleBindingList")
    @Valid
    private RoleBindingList roleBindingList;
    /**
     * 
     * 
     */
    @JsonProperty("RoleBindingRestriction")
    @Valid
    private RoleBindingRestriction roleBindingRestriction;
    /**
     * 
     * 
     */
    @JsonProperty("RoleList")
    @Valid
    private RoleList roleList;
    /**
     * 
     * 
     */
    @JsonProperty("RootPaths")
    @Valid
    private RootPaths rootPaths;
    /**
     * 
     * 
     */
    @JsonProperty("RouteList")
    @Valid
    private RouteList routeList;
    /**
     * 
     * 
     */
    @JsonProperty("Scale")
    @Valid
    private Scale scale;
    /**
     * 
     * 
     */
    @JsonProperty("Secret")
    @Valid
    private Secret secret;
    /**
     * 
     * 
     */
    @JsonProperty("SecretList")
    @Valid
    private SecretList secretList;
    /**
     * 
     * 
     */
    @JsonProperty("SecurityContextConstraints")
    @Valid
    private SecurityContextConstraints securityContextConstraints;
    /**
     * 
     * 
     */
    @JsonProperty("SecurityContextConstraintsList")
    @Valid
    private SecurityContextConstraintsList securityContextConstraintsList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceAccount")
    @Valid
    private ServiceAccount serviceAccount;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceAccountList")
    @Valid
    private ServiceAccountList serviceAccountList;
    /**
     * 
     * 
     */
    @JsonProperty("ServiceList")
    @Valid
    private ServiceList serviceList;
    /**
     * 
     * 
     */
    @JsonProperty("StatefulSet")
    @Valid
    private StatefulSet statefulSet;
    /**
     * 
     * 
     */
    @JsonProperty("StatefulSetList")
    @Valid
    private StatefulSetList statefulSetList;
    /**
     * 
     * 
     */
    @JsonProperty("Status")
    @Valid
    private Status status;
    /**
     * 
     * 
     */
    @JsonProperty("SubjectAccessReview")
    @Valid
    private SubjectAccessReview subjectAccessReview;
    /**
     * 
     * 
     */
    @JsonProperty("SubjectAccessReviewResponse")
    @Valid
    private SubjectAccessReviewResponse subjectAccessReviewResponse;
    /**
     * 
     * 
     */
    @JsonProperty("TagEvent")
    @Valid
    private TagEvent tagEvent;
    /**
     * 
     * 
     */
    @JsonProperty("Template")
    @Valid
    private Template template;
    /**
     * 
     * 
     */
    @JsonProperty("TemplateList")
    @Valid
    private TemplateList templateList;
    /**
     * 
     * 
     */
    @JsonProperty("ThirdPartyResource")
    @Valid
    private ThirdPartyResource thirdPartyResource;
    /**
     * 
     * 
     */
    @JsonProperty("ThirdPartyResourceList")
    @Valid
    private ThirdPartyResourceList thirdPartyResourceList;
    /**
     * 
     * 
     */
    @JsonProperty("User")
    @Valid
    private User user;
    /**
     * 
     * 
     */
    @JsonProperty("UserList")
    @Valid
    private UserList userList;
    /**
     * 
     * 
     */
    @JsonProperty("WatchEvent")
    @Valid
    private WatchEvent watchEvent;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public KubeSchema() {
    }

    /**
     * 
     * @param clusterPolicyBinding
     * @param roleBinding
     * @param policyList
     * @param binding
     * @param daemonSet
     * @param daemonSetList
     * @param patch
     * @param policyBindingList
     * @param securityContextConstraintsList
     * @param oAuthClientAuthorizationList
     * @param serviceAccountList
     * @param userList
     * @param secretList
     * @param clusterRoleBindingList
     * @param deleteOptions
     * @param networkPolicy
     * @param groupList
     * @param tagEvent
     * @param projectRequest
     * @param roleList
     * @param nodeList
     * @param node
     * @param roleBindingRestriction
     * @param imageList
     * @param persistentVolumeClaimList
     * @param status
     * @param template
     * @param buildRequest
     * @param role
     * @param ingressList
     * @param baseKubernetesList
     * @param statefulSetList
     * @param subjectAccessReviewResponse
     * @param podList
     * @param secret
     * @param identity
     * @param oAuthAccessTokenList
     * @param buildList
     * @param rootPaths
     * @param containerStatus
     * @param horizontalPodAutoscalerList
     * @param replicaSetList
     * @param deployment
     * @param policy
     * @param oAuthClientList
     * @param endpoints
     * @param oAuthAuthorizeTokenList
     * @param envVar
     * @param thirdPartyResource
     * @param policyBinding
     * @param objectMeta
     * @param componentStatusList
     * @param oAuthClient
     * @param config
     * @param routeList
     * @param securityContextConstraints
     * @param thirdPartyResourceList
     * @param deploymentRollback
     * @param configMapList
     * @param eventList
     * @param project
     * @param namespaceList
     * @param clusterPolicyBindingList
     * @param persistentVolume
     * @param resourceQuota
     * @param watchEvent
     * @param clusterPolicy
     * @param cronJobList
     * @param group
     * @param projectList
     * @param oAuthAccessToken
     * @param imageStreamList
     * @param limitRangeList
     * @param deploymentList
     * @param oAuthClientAuthorization
     * @param imageStreamTagList
     * @param replicaSet
     * @param cronJob
     * @param clusterPolicyList
     * @param buildConfigList
     * @param ingress
     * @param configMap
     * @param identityList
     * @param subjectAccessReview
     * @param job
     * @param jobList
     * @param replicationControllerList
     * @param scale
     * @param roleBindingList
     * @param oAuthAuthorizeToken
     * @param persistentVolumeList
     * @param localSubjectAccessReview
     * @param endpointsList
     * @param quantity
     * @param networkPolicyList
     * @param templateList
     * @param serviceAccount
     * @param horizontalPodAutoscaler
     * @param resourceQuotaList
     * @param podTemplateList
     * @param deploymentConfigList
     * @param listMeta
     * @param statefulSet
     * @param namespace
     * @param serviceList
     * @param clusterRoleBinding
     * @param persistentVolumeClaim
     * @param user
     */
    public KubeSchema(BaseKubernetesList baseKubernetesList, Binding binding, BuildConfigList buildConfigList, BuildList buildList, BuildRequest buildRequest, ClusterPolicy clusterPolicy, ClusterPolicyBinding clusterPolicyBinding, ClusterPolicyBindingList clusterPolicyBindingList, ClusterPolicyList clusterPolicyList, ClusterRoleBinding clusterRoleBinding, ClusterRoleBindingList clusterRoleBindingList, ComponentStatusList componentStatusList, Config config, ConfigMap configMap, ConfigMapList configMapList, ContainerStatus containerStatus, CronJob cronJob, CronJobList cronJobList, DaemonSet daemonSet, DaemonSetList daemonSetList, DeleteOptions deleteOptions, Deployment deployment, DeploymentConfigList deploymentConfigList, DeploymentList deploymentList, DeploymentRollback deploymentRollback, Endpoints endpoints, EndpointsList endpointsList, EnvVar envVar, EventList eventList, Group group, GroupList groupList, HorizontalPodAutoscaler horizontalPodAutoscaler, HorizontalPodAutoscalerList horizontalPodAutoscalerList, Identity identity, IdentityList identityList, ImageList imageList, ImageStreamList imageStreamList, ImageStreamTagList imageStreamTagList, Ingress ingress, IngressList ingressList, Job job, JobList jobList, LimitRangeList limitRangeList, ListMeta listMeta, LocalSubjectAccessReview localSubjectAccessReview, Namespace namespace, NamespaceList namespaceList, Node node, NodeList nodeList, OAuthAccessToken oAuthAccessToken, OAuthAccessTokenList oAuthAccessTokenList, OAuthAuthorizeToken oAuthAuthorizeToken, OAuthAuthorizeTokenList oAuthAuthorizeTokenList, OAuthClient oAuthClient, OAuthClientAuthorization oAuthClientAuthorization, OAuthClientAuthorizationList oAuthClientAuthorizationList, OAuthClientList oAuthClientList, ObjectMeta objectMeta, Patch patch, PersistentVolume persistentVolume, PersistentVolumeClaim persistentVolumeClaim, PersistentVolumeClaimList persistentVolumeClaimList, PersistentVolumeList persistentVolumeList, PodList podList, PodTemplateList podTemplateList, Policy policy, PolicyBinding policyBinding, PolicyBindingList policyBindingList, PolicyList policyList, Project project, ProjectList projectList, ProjectRequest projectRequest, Quantity quantity, ReplicaSet replicaSet, ReplicaSetList replicaSetList, NetworkPolicy networkPolicy, NetworkPolicyList networkPolicyList, ReplicationControllerList replicationControllerList, ResourceQuota resourceQuota, ResourceQuotaList resourceQuotaList, Role role, RoleBinding roleBinding, RoleBindingList roleBindingList, RoleBindingRestriction roleBindingRestriction, RoleList roleList, RootPaths rootPaths, RouteList routeList, Scale scale, Secret secret, SecretList secretList, SecurityContextConstraints securityContextConstraints, SecurityContextConstraintsList securityContextConstraintsList, ServiceAccount serviceAccount, ServiceAccountList serviceAccountList, ServiceList serviceList, StatefulSet statefulSet, StatefulSetList statefulSetList, Status status, SubjectAccessReview subjectAccessReview, SubjectAccessReviewResponse subjectAccessReviewResponse, TagEvent tagEvent, Template template, TemplateList templateList, ThirdPartyResource thirdPartyResource, ThirdPartyResourceList thirdPartyResourceList, User user, UserList userList, WatchEvent watchEvent) {
        this.baseKubernetesList = baseKubernetesList;
        this.binding = binding;
        this.buildConfigList = buildConfigList;
        this.buildList = buildList;
        this.buildRequest = buildRequest;
        this.clusterPolicy = clusterPolicy;
        this.clusterPolicyBinding = clusterPolicyBinding;
        this.clusterPolicyBindingList = clusterPolicyBindingList;
        this.clusterPolicyList = clusterPolicyList;
        this.clusterRoleBinding = clusterRoleBinding;
        this.clusterRoleBindingList = clusterRoleBindingList;
        this.componentStatusList = componentStatusList;
        this.config = config;
        this.configMap = configMap;
        this.configMapList = configMapList;
        this.containerStatus = containerStatus;
        this.cronJob = cronJob;
        this.cronJobList = cronJobList;
        this.daemonSet = daemonSet;
        this.daemonSetList = daemonSetList;
        this.deleteOptions = deleteOptions;
        this.deployment = deployment;
        this.deploymentConfigList = deploymentConfigList;
        this.deploymentList = deploymentList;
        this.deploymentRollback = deploymentRollback;
        this.endpoints = endpoints;
        this.endpointsList = endpointsList;
        this.envVar = envVar;
        this.eventList = eventList;
        this.group = group;
        this.groupList = groupList;
        this.horizontalPodAutoscaler = horizontalPodAutoscaler;
        this.horizontalPodAutoscalerList = horizontalPodAutoscalerList;
        this.identity = identity;
        this.identityList = identityList;
        this.imageList = imageList;
        this.imageStreamList = imageStreamList;
        this.imageStreamTagList = imageStreamTagList;
        this.ingress = ingress;
        this.ingressList = ingressList;
        this.job = job;
        this.jobList = jobList;
        this.limitRangeList = limitRangeList;
        this.listMeta = listMeta;
        this.localSubjectAccessReview = localSubjectAccessReview;
        this.namespace = namespace;
        this.namespaceList = namespaceList;
        this.node = node;
        this.nodeList = nodeList;
        this.oAuthAccessToken = oAuthAccessToken;
        this.oAuthAccessTokenList = oAuthAccessTokenList;
        this.oAuthAuthorizeToken = oAuthAuthorizeToken;
        this.oAuthAuthorizeTokenList = oAuthAuthorizeTokenList;
        this.oAuthClient = oAuthClient;
        this.oAuthClientAuthorization = oAuthClientAuthorization;
        this.oAuthClientAuthorizationList = oAuthClientAuthorizationList;
        this.oAuthClientList = oAuthClientList;
        this.objectMeta = objectMeta;
        this.patch = patch;
        this.persistentVolume = persistentVolume;
        this.persistentVolumeClaim = persistentVolumeClaim;
        this.persistentVolumeClaimList = persistentVolumeClaimList;
        this.persistentVolumeList = persistentVolumeList;
        this.podList = podList;
        this.podTemplateList = podTemplateList;
        this.policy = policy;
        this.policyBinding = policyBinding;
        this.policyBindingList = policyBindingList;
        this.policyList = policyList;
        this.project = project;
        this.projectList = projectList;
        this.projectRequest = projectRequest;
        this.quantity = quantity;
        this.replicaSet = replicaSet;
        this.replicaSetList = replicaSetList;
        this.networkPolicy = networkPolicy;
        this.networkPolicyList = networkPolicyList;
        this.replicationControllerList = replicationControllerList;
        this.resourceQuota = resourceQuota;
        this.resourceQuotaList = resourceQuotaList;
        this.role = role;
        this.roleBinding = roleBinding;
        this.roleBindingList = roleBindingList;
        this.roleBindingRestriction = roleBindingRestriction;
        this.roleList = roleList;
        this.rootPaths = rootPaths;
        this.routeList = routeList;
        this.scale = scale;
        this.secret = secret;
        this.secretList = secretList;
        this.securityContextConstraints = securityContextConstraints;
        this.securityContextConstraintsList = securityContextConstraintsList;
        this.serviceAccount = serviceAccount;
        this.serviceAccountList = serviceAccountList;
        this.serviceList = serviceList;
        this.statefulSet = statefulSet;
        this.statefulSetList = statefulSetList;
        this.status = status;
        this.subjectAccessReview = subjectAccessReview;
        this.subjectAccessReviewResponse = subjectAccessReviewResponse;
        this.tagEvent = tagEvent;
        this.template = template;
        this.templateList = templateList;
        this.thirdPartyResource = thirdPartyResource;
        this.thirdPartyResourceList = thirdPartyResourceList;
        this.user = user;
        this.userList = userList;
        this.watchEvent = watchEvent;
    }

    /**
     * 
     * 
     * @return
     *     The baseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public BaseKubernetesList getBaseKubernetesList() {
        return baseKubernetesList;
    }

    /**
     * 
     * 
     * @param baseKubernetesList
     *     The BaseKubernetesList
     */
    @JsonProperty("BaseKubernetesList")
    public void setBaseKubernetesList(BaseKubernetesList baseKubernetesList) {
        this.baseKubernetesList = baseKubernetesList;
    }

    /**
     * 
     * 
     * @return
     *     The binding
     */
    @JsonProperty("Binding")
    public Binding getBinding() {
        return binding;
    }

    /**
     * 
     * 
     * @param binding
     *     The Binding
     */
    @JsonProperty("Binding")
    public void setBinding(Binding binding) {
        this.binding = binding;
    }

    /**
     * 
     * 
     * @return
     *     The buildConfigList
     */
    @JsonProperty("BuildConfigList")
    public BuildConfigList getBuildConfigList() {
        return buildConfigList;
    }

    /**
     * 
     * 
     * @param buildConfigList
     *     The BuildConfigList
     */
    @JsonProperty("BuildConfigList")
    public void setBuildConfigList(BuildConfigList buildConfigList) {
        this.buildConfigList = buildConfigList;
    }

    /**
     * 
     * 
     * @return
     *     The buildList
     */
    @JsonProperty("BuildList")
    public BuildList getBuildList() {
        return buildList;
    }

    /**
     * 
     * 
     * @param buildList
     *     The BuildList
     */
    @JsonProperty("BuildList")
    public void setBuildList(BuildList buildList) {
        this.buildList = buildList;
    }

    /**
     * 
     * 
     * @return
     *     The buildRequest
     */
    @JsonProperty("BuildRequest")
    public BuildRequest getBuildRequest() {
        return buildRequest;
    }

    /**
     * 
     * 
     * @param buildRequest
     *     The BuildRequest
     */
    @JsonProperty("BuildRequest")
    public void setBuildRequest(BuildRequest buildRequest) {
        this.buildRequest = buildRequest;
    }

    /**
     * 
     * 
     * @return
     *     The clusterPolicy
     */
    @JsonProperty("ClusterPolicy")
    public ClusterPolicy getClusterPolicy() {
        return clusterPolicy;
    }

    /**
     * 
     * 
     * @param clusterPolicy
     *     The ClusterPolicy
     */
    @JsonProperty("ClusterPolicy")
    public void setClusterPolicy(ClusterPolicy clusterPolicy) {
        this.clusterPolicy = clusterPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The clusterPolicyBinding
     */
    @JsonProperty("ClusterPolicyBinding")
    public ClusterPolicyBinding getClusterPolicyBinding() {
        return clusterPolicyBinding;
    }

    /**
     * 
     * 
     * @param clusterPolicyBinding
     *     The ClusterPolicyBinding
     */
    @JsonProperty("ClusterPolicyBinding")
    public void setClusterPolicyBinding(ClusterPolicyBinding clusterPolicyBinding) {
        this.clusterPolicyBinding = clusterPolicyBinding;
    }

    /**
     * 
     * 
     * @return
     *     The clusterPolicyBindingList
     */
    @JsonProperty("ClusterPolicyBindingList")
    public ClusterPolicyBindingList getClusterPolicyBindingList() {
        return clusterPolicyBindingList;
    }

    /**
     * 
     * 
     * @param clusterPolicyBindingList
     *     The ClusterPolicyBindingList
     */
    @JsonProperty("ClusterPolicyBindingList")
    public void setClusterPolicyBindingList(ClusterPolicyBindingList clusterPolicyBindingList) {
        this.clusterPolicyBindingList = clusterPolicyBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterPolicyList
     */
    @JsonProperty("ClusterPolicyList")
    public ClusterPolicyList getClusterPolicyList() {
        return clusterPolicyList;
    }

    /**
     * 
     * 
     * @param clusterPolicyList
     *     The ClusterPolicyList
     */
    @JsonProperty("ClusterPolicyList")
    public void setClusterPolicyList(ClusterPolicyList clusterPolicyList) {
        this.clusterPolicyList = clusterPolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The clusterRoleBinding
     */
    @JsonProperty("ClusterRoleBinding")
    public ClusterRoleBinding getClusterRoleBinding() {
        return clusterRoleBinding;
    }

    /**
     * 
     * 
     * @param clusterRoleBinding
     *     The ClusterRoleBinding
     */
    @JsonProperty("ClusterRoleBinding")
    public void setClusterRoleBinding(ClusterRoleBinding clusterRoleBinding) {
        this.clusterRoleBinding = clusterRoleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The clusterRoleBindingList
     */
    @JsonProperty("ClusterRoleBindingList")
    public ClusterRoleBindingList getClusterRoleBindingList() {
        return clusterRoleBindingList;
    }

    /**
     * 
     * 
     * @param clusterRoleBindingList
     *     The ClusterRoleBindingList
     */
    @JsonProperty("ClusterRoleBindingList")
    public void setClusterRoleBindingList(ClusterRoleBindingList clusterRoleBindingList) {
        this.clusterRoleBindingList = clusterRoleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The componentStatusList
     */
    @JsonProperty("ComponentStatusList")
    public ComponentStatusList getComponentStatusList() {
        return componentStatusList;
    }

    /**
     * 
     * 
     * @param componentStatusList
     *     The ComponentStatusList
     */
    @JsonProperty("ComponentStatusList")
    public void setComponentStatusList(ComponentStatusList componentStatusList) {
        this.componentStatusList = componentStatusList;
    }

    /**
     * 
     * 
     * @return
     *     The config
     */
    @JsonProperty("Config")
    public Config getConfig() {
        return config;
    }

    /**
     * 
     * 
     * @param config
     *     The Config
     */
    @JsonProperty("Config")
    public void setConfig(Config config) {
        this.config = config;
    }

    /**
     * 
     * 
     * @return
     *     The configMap
     */
    @JsonProperty("ConfigMap")
    public ConfigMap getConfigMap() {
        return configMap;
    }

    /**
     * 
     * 
     * @param configMap
     *     The ConfigMap
     */
    @JsonProperty("ConfigMap")
    public void setConfigMap(ConfigMap configMap) {
        this.configMap = configMap;
    }

    /**
     * 
     * 
     * @return
     *     The configMapList
     */
    @JsonProperty("ConfigMapList")
    public ConfigMapList getConfigMapList() {
        return configMapList;
    }

    /**
     * 
     * 
     * @param configMapList
     *     The ConfigMapList
     */
    @JsonProperty("ConfigMapList")
    public void setConfigMapList(ConfigMapList configMapList) {
        this.configMapList = configMapList;
    }

    /**
     * 
     * 
     * @return
     *     The containerStatus
     */
    @JsonProperty("ContainerStatus")
    public ContainerStatus getContainerStatus() {
        return containerStatus;
    }

    /**
     * 
     * 
     * @param containerStatus
     *     The ContainerStatus
     */
    @JsonProperty("ContainerStatus")
    public void setContainerStatus(ContainerStatus containerStatus) {
        this.containerStatus = containerStatus;
    }

    /**
     * 
     * 
     * @return
     *     The cronJob
     */
    @JsonProperty("CronJob")
    public CronJob getCronJob() {
        return cronJob;
    }

    /**
     * 
     * 
     * @param cronJob
     *     The CronJob
     */
    @JsonProperty("CronJob")
    public void setCronJob(CronJob cronJob) {
        this.cronJob = cronJob;
    }

    /**
     * 
     * 
     * @return
     *     The cronJobList
     */
    @JsonProperty("CronJobList")
    public CronJobList getCronJobList() {
        return cronJobList;
    }

    /**
     * 
     * 
     * @param cronJobList
     *     The CronJobList
     */
    @JsonProperty("CronJobList")
    public void setCronJobList(CronJobList cronJobList) {
        this.cronJobList = cronJobList;
    }

    /**
     * 
     * 
     * @return
     *     The daemonSet
     */
    @JsonProperty("DaemonSet")
    public DaemonSet getDaemonSet() {
        return daemonSet;
    }

    /**
     * 
     * 
     * @param daemonSet
     *     The DaemonSet
     */
    @JsonProperty("DaemonSet")
    public void setDaemonSet(DaemonSet daemonSet) {
        this.daemonSet = daemonSet;
    }

    /**
     * 
     * 
     * @return
     *     The daemonSetList
     */
    @JsonProperty("DaemonSetList")
    public DaemonSetList getDaemonSetList() {
        return daemonSetList;
    }

    /**
     * 
     * 
     * @param daemonSetList
     *     The DaemonSetList
     */
    @JsonProperty("DaemonSetList")
    public void setDaemonSetList(DaemonSetList daemonSetList) {
        this.daemonSetList = daemonSetList;
    }

    /**
     * 
     * 
     * @return
     *     The deleteOptions
     */
    @JsonProperty("DeleteOptions")
    public DeleteOptions getDeleteOptions() {
        return deleteOptions;
    }

    /**
     * 
     * 
     * @param deleteOptions
     *     The DeleteOptions
     */
    @JsonProperty("DeleteOptions")
    public void setDeleteOptions(DeleteOptions deleteOptions) {
        this.deleteOptions = deleteOptions;
    }

    /**
     * 
     * 
     * @return
     *     The deployment
     */
    @JsonProperty("Deployment")
    public Deployment getDeployment() {
        return deployment;
    }

    /**
     * 
     * 
     * @param deployment
     *     The Deployment
     */
    @JsonProperty("Deployment")
    public void setDeployment(Deployment deployment) {
        this.deployment = deployment;
    }

    /**
     * 
     * 
     * @return
     *     The deploymentConfigList
     */
    @JsonProperty("DeploymentConfigList")
    public DeploymentConfigList getDeploymentConfigList() {
        return deploymentConfigList;
    }

    /**
     * 
     * 
     * @param deploymentConfigList
     *     The DeploymentConfigList
     */
    @JsonProperty("DeploymentConfigList")
    public void setDeploymentConfigList(DeploymentConfigList deploymentConfigList) {
        this.deploymentConfigList = deploymentConfigList;
    }

    /**
     * 
     * 
     * @return
     *     The deploymentList
     */
    @JsonProperty("DeploymentList")
    public DeploymentList getDeploymentList() {
        return deploymentList;
    }

    /**
     * 
     * 
     * @param deploymentList
     *     The DeploymentList
     */
    @JsonProperty("DeploymentList")
    public void setDeploymentList(DeploymentList deploymentList) {
        this.deploymentList = deploymentList;
    }

    /**
     * 
     * 
     * @return
     *     The deploymentRollback
     */
    @JsonProperty("DeploymentRollback")
    public DeploymentRollback getDeploymentRollback() {
        return deploymentRollback;
    }

    /**
     * 
     * 
     * @param deploymentRollback
     *     The DeploymentRollback
     */
    @JsonProperty("DeploymentRollback")
    public void setDeploymentRollback(DeploymentRollback deploymentRollback) {
        this.deploymentRollback = deploymentRollback;
    }

    /**
     * 
     * 
     * @return
     *     The endpoints
     */
    @JsonProperty("Endpoints")
    public Endpoints getEndpoints() {
        return endpoints;
    }

    /**
     * 
     * 
     * @param endpoints
     *     The Endpoints
     */
    @JsonProperty("Endpoints")
    public void setEndpoints(Endpoints endpoints) {
        this.endpoints = endpoints;
    }

    /**
     * 
     * 
     * @return
     *     The endpointsList
     */
    @JsonProperty("EndpointsList")
    public EndpointsList getEndpointsList() {
        return endpointsList;
    }

    /**
     * 
     * 
     * @param endpointsList
     *     The EndpointsList
     */
    @JsonProperty("EndpointsList")
    public void setEndpointsList(EndpointsList endpointsList) {
        this.endpointsList = endpointsList;
    }

    /**
     * 
     * 
     * @return
     *     The envVar
     */
    @JsonProperty("EnvVar")
    public EnvVar getEnvVar() {
        return envVar;
    }

    /**
     * 
     * 
     * @param envVar
     *     The EnvVar
     */
    @JsonProperty("EnvVar")
    public void setEnvVar(EnvVar envVar) {
        this.envVar = envVar;
    }

    /**
     * 
     * 
     * @return
     *     The eventList
     */
    @JsonProperty("EventList")
    public EventList getEventList() {
        return eventList;
    }

    /**
     * 
     * 
     * @param eventList
     *     The EventList
     */
    @JsonProperty("EventList")
    public void setEventList(EventList eventList) {
        this.eventList = eventList;
    }

    /**
     * 
     * 
     * @return
     *     The group
     */
    @JsonProperty("Group")
    public Group getGroup() {
        return group;
    }

    /**
     * 
     * 
     * @param group
     *     The Group
     */
    @JsonProperty("Group")
    public void setGroup(Group group) {
        this.group = group;
    }

    /**
     * 
     * 
     * @return
     *     The groupList
     */
    @JsonProperty("GroupList")
    public GroupList getGroupList() {
        return groupList;
    }

    /**
     * 
     * 
     * @param groupList
     *     The GroupList
     */
    @JsonProperty("GroupList")
    public void setGroupList(GroupList groupList) {
        this.groupList = groupList;
    }

    /**
     * 
     * 
     * @return
     *     The horizontalPodAutoscaler
     */
    @JsonProperty("HorizontalPodAutoscaler")
    public HorizontalPodAutoscaler getHorizontalPodAutoscaler() {
        return horizontalPodAutoscaler;
    }

    /**
     * 
     * 
     * @param horizontalPodAutoscaler
     *     The HorizontalPodAutoscaler
     */
    @JsonProperty("HorizontalPodAutoscaler")
    public void setHorizontalPodAutoscaler(HorizontalPodAutoscaler horizontalPodAutoscaler) {
        this.horizontalPodAutoscaler = horizontalPodAutoscaler;
    }

    /**
     * 
     * 
     * @return
     *     The horizontalPodAutoscalerList
     */
    @JsonProperty("HorizontalPodAutoscalerList")
    public HorizontalPodAutoscalerList getHorizontalPodAutoscalerList() {
        return horizontalPodAutoscalerList;
    }

    /**
     * 
     * 
     * @param horizontalPodAutoscalerList
     *     The HorizontalPodAutoscalerList
     */
    @JsonProperty("HorizontalPodAutoscalerList")
    public void setHorizontalPodAutoscalerList(HorizontalPodAutoscalerList horizontalPodAutoscalerList) {
        this.horizontalPodAutoscalerList = horizontalPodAutoscalerList;
    }

    /**
     * 
     * 
     * @return
     *     The identity
     */
    @JsonProperty("Identity")
    public Identity getIdentity() {
        return identity;
    }

    /**
     * 
     * 
     * @param identity
     *     The Identity
     */
    @JsonProperty("Identity")
    public void setIdentity(Identity identity) {
        this.identity = identity;
    }

    /**
     * 
     * 
     * @return
     *     The identityList
     */
    @JsonProperty("IdentityList")
    public IdentityList getIdentityList() {
        return identityList;
    }

    /**
     * 
     * 
     * @param identityList
     *     The IdentityList
     */
    @JsonProperty("IdentityList")
    public void setIdentityList(IdentityList identityList) {
        this.identityList = identityList;
    }

    /**
     * 
     * 
     * @return
     *     The imageList
     */
    @JsonProperty("ImageList")
    public ImageList getImageList() {
        return imageList;
    }

    /**
     * 
     * 
     * @param imageList
     *     The ImageList
     */
    @JsonProperty("ImageList")
    public void setImageList(ImageList imageList) {
        this.imageList = imageList;
    }

    /**
     * 
     * 
     * @return
     *     The imageStreamList
     */
    @JsonProperty("ImageStreamList")
    public ImageStreamList getImageStreamList() {
        return imageStreamList;
    }

    /**
     * 
     * 
     * @param imageStreamList
     *     The ImageStreamList
     */
    @JsonProperty("ImageStreamList")
    public void setImageStreamList(ImageStreamList imageStreamList) {
        this.imageStreamList = imageStreamList;
    }

    /**
     * 
     * 
     * @return
     *     The imageStreamTagList
     */
    @JsonProperty("ImageStreamTagList")
    public ImageStreamTagList getImageStreamTagList() {
        return imageStreamTagList;
    }

    /**
     * 
     * 
     * @param imageStreamTagList
     *     The ImageStreamTagList
     */
    @JsonProperty("ImageStreamTagList")
    public void setImageStreamTagList(ImageStreamTagList imageStreamTagList) {
        this.imageStreamTagList = imageStreamTagList;
    }

    /**
     * 
     * 
     * @return
     *     The ingress
     */
    @JsonProperty("Ingress")
    public Ingress getIngress() {
        return ingress;
    }

    /**
     * 
     * 
     * @param ingress
     *     The Ingress
     */
    @JsonProperty("Ingress")
    public void setIngress(Ingress ingress) {
        this.ingress = ingress;
    }

    /**
     * 
     * 
     * @return
     *     The ingressList
     */
    @JsonProperty("IngressList")
    public IngressList getIngressList() {
        return ingressList;
    }

    /**
     * 
     * 
     * @param ingressList
     *     The IngressList
     */
    @JsonProperty("IngressList")
    public void setIngressList(IngressList ingressList) {
        this.ingressList = ingressList;
    }

    /**
     * 
     * 
     * @return
     *     The job
     */
    @JsonProperty("Job")
    public Job getJob() {
        return job;
    }

    /**
     * 
     * 
     * @param job
     *     The Job
     */
    @JsonProperty("Job")
    public void setJob(Job job) {
        this.job = job;
    }

    /**
     * 
     * 
     * @return
     *     The jobList
     */
    @JsonProperty("JobList")
    public JobList getJobList() {
        return jobList;
    }

    /**
     * 
     * 
     * @param jobList
     *     The JobList
     */
    @JsonProperty("JobList")
    public void setJobList(JobList jobList) {
        this.jobList = jobList;
    }

    /**
     * 
     * 
     * @return
     *     The limitRangeList
     */
    @JsonProperty("LimitRangeList")
    public LimitRangeList getLimitRangeList() {
        return limitRangeList;
    }

    /**
     * 
     * 
     * @param limitRangeList
     *     The LimitRangeList
     */
    @JsonProperty("LimitRangeList")
    public void setLimitRangeList(LimitRangeList limitRangeList) {
        this.limitRangeList = limitRangeList;
    }

    /**
     * 
     * 
     * @return
     *     The listMeta
     */
    @JsonProperty("ListMeta")
    public ListMeta getListMeta() {
        return listMeta;
    }

    /**
     * 
     * 
     * @param listMeta
     *     The ListMeta
     */
    @JsonProperty("ListMeta")
    public void setListMeta(ListMeta listMeta) {
        this.listMeta = listMeta;
    }

    /**
     * 
     * 
     * @return
     *     The localSubjectAccessReview
     */
    @JsonProperty("LocalSubjectAccessReview")
    public LocalSubjectAccessReview getLocalSubjectAccessReview() {
        return localSubjectAccessReview;
    }

    /**
     * 
     * 
     * @param localSubjectAccessReview
     *     The LocalSubjectAccessReview
     */
    @JsonProperty("LocalSubjectAccessReview")
    public void setLocalSubjectAccessReview(LocalSubjectAccessReview localSubjectAccessReview) {
        this.localSubjectAccessReview = localSubjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The namespace
     */
    @JsonProperty("Namespace")
    public Namespace getNamespace() {
        return namespace;
    }

    /**
     * 
     * 
     * @param namespace
     *     The Namespace
     */
    @JsonProperty("Namespace")
    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    /**
     * 
     * 
     * @return
     *     The namespaceList
     */
    @JsonProperty("NamespaceList")
    public NamespaceList getNamespaceList() {
        return namespaceList;
    }

    /**
     * 
     * 
     * @param namespaceList
     *     The NamespaceList
     */
    @JsonProperty("NamespaceList")
    public void setNamespaceList(NamespaceList namespaceList) {
        this.namespaceList = namespaceList;
    }

    /**
     * 
     * 
     * @return
     *     The node
     */
    @JsonProperty("Node")
    public Node getNode() {
        return node;
    }

    /**
     * 
     * 
     * @param node
     *     The Node
     */
    @JsonProperty("Node")
    public void setNode(Node node) {
        this.node = node;
    }

    /**
     * 
     * 
     * @return
     *     The nodeList
     */
    @JsonProperty("NodeList")
    public NodeList getNodeList() {
        return nodeList;
    }

    /**
     * 
     * 
     * @param nodeList
     *     The NodeList
     */
    @JsonProperty("NodeList")
    public void setNodeList(NodeList nodeList) {
        this.nodeList = nodeList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAccessToken
     */
    @JsonProperty("OAuthAccessToken")
    public OAuthAccessToken getOAuthAccessToken() {
        return oAuthAccessToken;
    }

    /**
     * 
     * 
     * @param oAuthAccessToken
     *     The OAuthAccessToken
     */
    @JsonProperty("OAuthAccessToken")
    public void setOAuthAccessToken(OAuthAccessToken oAuthAccessToken) {
        this.oAuthAccessToken = oAuthAccessToken;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAccessTokenList
     */
    @JsonProperty("OAuthAccessTokenList")
    public OAuthAccessTokenList getOAuthAccessTokenList() {
        return oAuthAccessTokenList;
    }

    /**
     * 
     * 
     * @param oAuthAccessTokenList
     *     The OAuthAccessTokenList
     */
    @JsonProperty("OAuthAccessTokenList")
    public void setOAuthAccessTokenList(OAuthAccessTokenList oAuthAccessTokenList) {
        this.oAuthAccessTokenList = oAuthAccessTokenList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAuthorizeToken
     */
    @JsonProperty("OAuthAuthorizeToken")
    public OAuthAuthorizeToken getOAuthAuthorizeToken() {
        return oAuthAuthorizeToken;
    }

    /**
     * 
     * 
     * @param oAuthAuthorizeToken
     *     The OAuthAuthorizeToken
     */
    @JsonProperty("OAuthAuthorizeToken")
    public void setOAuthAuthorizeToken(OAuthAuthorizeToken oAuthAuthorizeToken) {
        this.oAuthAuthorizeToken = oAuthAuthorizeToken;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthAuthorizeTokenList
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    public OAuthAuthorizeTokenList getOAuthAuthorizeTokenList() {
        return oAuthAuthorizeTokenList;
    }

    /**
     * 
     * 
     * @param oAuthAuthorizeTokenList
     *     The OAuthAuthorizeTokenList
     */
    @JsonProperty("OAuthAuthorizeTokenList")
    public void setOAuthAuthorizeTokenList(OAuthAuthorizeTokenList oAuthAuthorizeTokenList) {
        this.oAuthAuthorizeTokenList = oAuthAuthorizeTokenList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClient
     */
    @JsonProperty("OAuthClient")
    public OAuthClient getOAuthClient() {
        return oAuthClient;
    }

    /**
     * 
     * 
     * @param oAuthClient
     *     The OAuthClient
     */
    @JsonProperty("OAuthClient")
    public void setOAuthClient(OAuthClient oAuthClient) {
        this.oAuthClient = oAuthClient;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClientAuthorization
     */
    @JsonProperty("OAuthClientAuthorization")
    public OAuthClientAuthorization getOAuthClientAuthorization() {
        return oAuthClientAuthorization;
    }

    /**
     * 
     * 
     * @param oAuthClientAuthorization
     *     The OAuthClientAuthorization
     */
    @JsonProperty("OAuthClientAuthorization")
    public void setOAuthClientAuthorization(OAuthClientAuthorization oAuthClientAuthorization) {
        this.oAuthClientAuthorization = oAuthClientAuthorization;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClientAuthorizationList
     */
    @JsonProperty("OAuthClientAuthorizationList")
    public OAuthClientAuthorizationList getOAuthClientAuthorizationList() {
        return oAuthClientAuthorizationList;
    }

    /**
     * 
     * 
     * @param oAuthClientAuthorizationList
     *     The OAuthClientAuthorizationList
     */
    @JsonProperty("OAuthClientAuthorizationList")
    public void setOAuthClientAuthorizationList(OAuthClientAuthorizationList oAuthClientAuthorizationList) {
        this.oAuthClientAuthorizationList = oAuthClientAuthorizationList;
    }

    /**
     * 
     * 
     * @return
     *     The oAuthClientList
     */
    @JsonProperty("OAuthClientList")
    public OAuthClientList getOAuthClientList() {
        return oAuthClientList;
    }

    /**
     * 
     * 
     * @param oAuthClientList
     *     The OAuthClientList
     */
    @JsonProperty("OAuthClientList")
    public void setOAuthClientList(OAuthClientList oAuthClientList) {
        this.oAuthClientList = oAuthClientList;
    }

    /**
     * 
     * 
     * @return
     *     The objectMeta
     */
    @JsonProperty("ObjectMeta")
    public ObjectMeta getObjectMeta() {
        return objectMeta;
    }

    /**
     * 
     * 
     * @param objectMeta
     *     The ObjectMeta
     */
    @JsonProperty("ObjectMeta")
    public void setObjectMeta(ObjectMeta objectMeta) {
        this.objectMeta = objectMeta;
    }

    /**
     * 
     * 
     * @return
     *     The patch
     */
    @JsonProperty("Patch")
    public Patch getPatch() {
        return patch;
    }

    /**
     * 
     * 
     * @param patch
     *     The Patch
     */
    @JsonProperty("Patch")
    public void setPatch(Patch patch) {
        this.patch = patch;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolume
     */
    @JsonProperty("PersistentVolume")
    public PersistentVolume getPersistentVolume() {
        return persistentVolume;
    }

    /**
     * 
     * 
     * @param persistentVolume
     *     The PersistentVolume
     */
    @JsonProperty("PersistentVolume")
    public void setPersistentVolume(PersistentVolume persistentVolume) {
        this.persistentVolume = persistentVolume;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolumeClaim
     */
    @JsonProperty("PersistentVolumeClaim")
    public PersistentVolumeClaim getPersistentVolumeClaim() {
        return persistentVolumeClaim;
    }

    /**
     * 
     * 
     * @param persistentVolumeClaim
     *     The PersistentVolumeClaim
     */
    @JsonProperty("PersistentVolumeClaim")
    public void setPersistentVolumeClaim(PersistentVolumeClaim persistentVolumeClaim) {
        this.persistentVolumeClaim = persistentVolumeClaim;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolumeClaimList
     */
    @JsonProperty("PersistentVolumeClaimList")
    public PersistentVolumeClaimList getPersistentVolumeClaimList() {
        return persistentVolumeClaimList;
    }

    /**
     * 
     * 
     * @param persistentVolumeClaimList
     *     The PersistentVolumeClaimList
     */
    @JsonProperty("PersistentVolumeClaimList")
    public void setPersistentVolumeClaimList(PersistentVolumeClaimList persistentVolumeClaimList) {
        this.persistentVolumeClaimList = persistentVolumeClaimList;
    }

    /**
     * 
     * 
     * @return
     *     The persistentVolumeList
     */
    @JsonProperty("PersistentVolumeList")
    public PersistentVolumeList getPersistentVolumeList() {
        return persistentVolumeList;
    }

    /**
     * 
     * 
     * @param persistentVolumeList
     *     The PersistentVolumeList
     */
    @JsonProperty("PersistentVolumeList")
    public void setPersistentVolumeList(PersistentVolumeList persistentVolumeList) {
        this.persistentVolumeList = persistentVolumeList;
    }

    /**
     * 
     * 
     * @return
     *     The podList
     */
    @JsonProperty("PodList")
    public PodList getPodList() {
        return podList;
    }

    /**
     * 
     * 
     * @param podList
     *     The PodList
     */
    @JsonProperty("PodList")
    public void setPodList(PodList podList) {
        this.podList = podList;
    }

    /**
     * 
     * 
     * @return
     *     The podTemplateList
     */
    @JsonProperty("PodTemplateList")
    public PodTemplateList getPodTemplateList() {
        return podTemplateList;
    }

    /**
     * 
     * 
     * @param podTemplateList
     *     The PodTemplateList
     */
    @JsonProperty("PodTemplateList")
    public void setPodTemplateList(PodTemplateList podTemplateList) {
        this.podTemplateList = podTemplateList;
    }

    /**
     * 
     * 
     * @return
     *     The policy
     */
    @JsonProperty("Policy")
    public Policy getPolicy() {
        return policy;
    }

    /**
     * 
     * 
     * @param policy
     *     The Policy
     */
    @JsonProperty("Policy")
    public void setPolicy(Policy policy) {
        this.policy = policy;
    }

    /**
     * 
     * 
     * @return
     *     The policyBinding
     */
    @JsonProperty("PolicyBinding")
    public PolicyBinding getPolicyBinding() {
        return policyBinding;
    }

    /**
     * 
     * 
     * @param policyBinding
     *     The PolicyBinding
     */
    @JsonProperty("PolicyBinding")
    public void setPolicyBinding(PolicyBinding policyBinding) {
        this.policyBinding = policyBinding;
    }

    /**
     * 
     * 
     * @return
     *     The policyBindingList
     */
    @JsonProperty("PolicyBindingList")
    public PolicyBindingList getPolicyBindingList() {
        return policyBindingList;
    }

    /**
     * 
     * 
     * @param policyBindingList
     *     The PolicyBindingList
     */
    @JsonProperty("PolicyBindingList")
    public void setPolicyBindingList(PolicyBindingList policyBindingList) {
        this.policyBindingList = policyBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The policyList
     */
    @JsonProperty("PolicyList")
    public PolicyList getPolicyList() {
        return policyList;
    }

    /**
     * 
     * 
     * @param policyList
     *     The PolicyList
     */
    @JsonProperty("PolicyList")
    public void setPolicyList(PolicyList policyList) {
        this.policyList = policyList;
    }

    /**
     * 
     * 
     * @return
     *     The project
     */
    @JsonProperty("Project")
    public Project getProject() {
        return project;
    }

    /**
     * 
     * 
     * @param project
     *     The Project
     */
    @JsonProperty("Project")
    public void setProject(Project project) {
        this.project = project;
    }

    /**
     * 
     * 
     * @return
     *     The projectList
     */
    @JsonProperty("ProjectList")
    public ProjectList getProjectList() {
        return projectList;
    }

    /**
     * 
     * 
     * @param projectList
     *     The ProjectList
     */
    @JsonProperty("ProjectList")
    public void setProjectList(ProjectList projectList) {
        this.projectList = projectList;
    }

    /**
     * 
     * 
     * @return
     *     The projectRequest
     */
    @JsonProperty("ProjectRequest")
    public ProjectRequest getProjectRequest() {
        return projectRequest;
    }

    /**
     * 
     * 
     * @param projectRequest
     *     The ProjectRequest
     */
    @JsonProperty("ProjectRequest")
    public void setProjectRequest(ProjectRequest projectRequest) {
        this.projectRequest = projectRequest;
    }

    /**
     * 
     * 
     * @return
     *     The quantity
     */
    @JsonProperty("Quantity")
    public Quantity getQuantity() {
        return quantity;
    }

    /**
     * 
     * 
     * @param quantity
     *     The Quantity
     */
    @JsonProperty("Quantity")
    public void setQuantity(Quantity quantity) {
        this.quantity = quantity;
    }

    /**
     * 
     * 
     * @return
     *     The replicaSet
     */
    @JsonProperty("ReplicaSet")
    public ReplicaSet getReplicaSet() {
        return replicaSet;
    }

    /**
     * 
     * 
     * @param replicaSet
     *     The ReplicaSet
     */
    @JsonProperty("ReplicaSet")
    public void setReplicaSet(ReplicaSet replicaSet) {
        this.replicaSet = replicaSet;
    }

    /**
     * 
     * 
     * @return
     *     The replicaSetList
     */
    @JsonProperty("ReplicaSetList")
    public ReplicaSetList getReplicaSetList() {
        return replicaSetList;
    }

    /**
     * 
     * 
     * @param replicaSetList
     *     The ReplicaSetList
     */
    @JsonProperty("ReplicaSetList")
    public void setReplicaSetList(ReplicaSetList replicaSetList) {
        this.replicaSetList = replicaSetList;
    }

    /**
     * 
     * 
     * @return
     *     The networkPolicy
     */
    @JsonProperty("NetworkPolicy")
    public NetworkPolicy getNetworkPolicy() {
        return networkPolicy;
    }

    /**
     * 
     * 
     * @param networkPolicy
     *     The NetworkPolicy
     */
    @JsonProperty("NetworkPolicy")
    public void setNetworkPolicy(NetworkPolicy networkPolicy) {
        this.networkPolicy = networkPolicy;
    }

    /**
     * 
     * 
     * @return
     *     The networkPolicyList
     */
    @JsonProperty("NetworkPolicyList")
    public NetworkPolicyList getNetworkPolicyList() {
        return networkPolicyList;
    }

    /**
     * 
     * 
     * @param networkPolicyList
     *     The NetworkPolicyList
     */
    @JsonProperty("NetworkPolicyList")
    public void setNetworkPolicyList(NetworkPolicyList networkPolicyList) {
        this.networkPolicyList = networkPolicyList;
    }

    /**
     * 
     * 
     * @return
     *     The replicationControllerList
     */
    @JsonProperty("ReplicationControllerList")
    public ReplicationControllerList getReplicationControllerList() {
        return replicationControllerList;
    }

    /**
     * 
     * 
     * @param replicationControllerList
     *     The ReplicationControllerList
     */
    @JsonProperty("ReplicationControllerList")
    public void setReplicationControllerList(ReplicationControllerList replicationControllerList) {
        this.replicationControllerList = replicationControllerList;
    }

    /**
     * 
     * 
     * @return
     *     The resourceQuota
     */
    @JsonProperty("ResourceQuota")
    public ResourceQuota getResourceQuota() {
        return resourceQuota;
    }

    /**
     * 
     * 
     * @param resourceQuota
     *     The ResourceQuota
     */
    @JsonProperty("ResourceQuota")
    public void setResourceQuota(ResourceQuota resourceQuota) {
        this.resourceQuota = resourceQuota;
    }

    /**
     * 
     * 
     * @return
     *     The resourceQuotaList
     */
    @JsonProperty("ResourceQuotaList")
    public ResourceQuotaList getResourceQuotaList() {
        return resourceQuotaList;
    }

    /**
     * 
     * 
     * @param resourceQuotaList
     *     The ResourceQuotaList
     */
    @JsonProperty("ResourceQuotaList")
    public void setResourceQuotaList(ResourceQuotaList resourceQuotaList) {
        this.resourceQuotaList = resourceQuotaList;
    }

    /**
     * 
     * 
     * @return
     *     The role
     */
    @JsonProperty("Role")
    public Role getRole() {
        return role;
    }

    /**
     * 
     * 
     * @param role
     *     The Role
     */
    @JsonProperty("Role")
    public void setRole(Role role) {
        this.role = role;
    }

    /**
     * 
     * 
     * @return
     *     The roleBinding
     */
    @JsonProperty("RoleBinding")
    public RoleBinding getRoleBinding() {
        return roleBinding;
    }

    /**
     * 
     * 
     * @param roleBinding
     *     The RoleBinding
     */
    @JsonProperty("RoleBinding")
    public void setRoleBinding(RoleBinding roleBinding) {
        this.roleBinding = roleBinding;
    }

    /**
     * 
     * 
     * @return
     *     The roleBindingList
     */
    @JsonProperty("RoleBindingList")
    public RoleBindingList getRoleBindingList() {
        return roleBindingList;
    }

    /**
     * 
     * 
     * @param roleBindingList
     *     The RoleBindingList
     */
    @JsonProperty("RoleBindingList")
    public void setRoleBindingList(RoleBindingList roleBindingList) {
        this.roleBindingList = roleBindingList;
    }

    /**
     * 
     * 
     * @return
     *     The roleBindingRestriction
     */
    @JsonProperty("RoleBindingRestriction")
    public RoleBindingRestriction getRoleBindingRestriction() {
        return roleBindingRestriction;
    }

    /**
     * 
     * 
     * @param roleBindingRestriction
     *     The RoleBindingRestriction
     */
    @JsonProperty("RoleBindingRestriction")
    public void setRoleBindingRestriction(RoleBindingRestriction roleBindingRestriction) {
        this.roleBindingRestriction = roleBindingRestriction;
    }

    /**
     * 
     * 
     * @return
     *     The roleList
     */
    @JsonProperty("RoleList")
    public RoleList getRoleList() {
        return roleList;
    }

    /**
     * 
     * 
     * @param roleList
     *     The RoleList
     */
    @JsonProperty("RoleList")
    public void setRoleList(RoleList roleList) {
        this.roleList = roleList;
    }

    /**
     * 
     * 
     * @return
     *     The rootPaths
     */
    @JsonProperty("RootPaths")
    public RootPaths getRootPaths() {
        return rootPaths;
    }

    /**
     * 
     * 
     * @param rootPaths
     *     The RootPaths
     */
    @JsonProperty("RootPaths")
    public void setRootPaths(RootPaths rootPaths) {
        this.rootPaths = rootPaths;
    }

    /**
     * 
     * 
     * @return
     *     The routeList
     */
    @JsonProperty("RouteList")
    public RouteList getRouteList() {
        return routeList;
    }

    /**
     * 
     * 
     * @param routeList
     *     The RouteList
     */
    @JsonProperty("RouteList")
    public void setRouteList(RouteList routeList) {
        this.routeList = routeList;
    }

    /**
     * 
     * 
     * @return
     *     The scale
     */
    @JsonProperty("Scale")
    public Scale getScale() {
        return scale;
    }

    /**
     * 
     * 
     * @param scale
     *     The Scale
     */
    @JsonProperty("Scale")
    public void setScale(Scale scale) {
        this.scale = scale;
    }

    /**
     * 
     * 
     * @return
     *     The secret
     */
    @JsonProperty("Secret")
    public Secret getSecret() {
        return secret;
    }

    /**
     * 
     * 
     * @param secret
     *     The Secret
     */
    @JsonProperty("Secret")
    public void setSecret(Secret secret) {
        this.secret = secret;
    }

    /**
     * 
     * 
     * @return
     *     The secretList
     */
    @JsonProperty("SecretList")
    public SecretList getSecretList() {
        return secretList;
    }

    /**
     * 
     * 
     * @param secretList
     *     The SecretList
     */
    @JsonProperty("SecretList")
    public void setSecretList(SecretList secretList) {
        this.secretList = secretList;
    }

    /**
     * 
     * 
     * @return
     *     The securityContextConstraints
     */
    @JsonProperty("SecurityContextConstraints")
    public SecurityContextConstraints getSecurityContextConstraints() {
        return securityContextConstraints;
    }

    /**
     * 
     * 
     * @param securityContextConstraints
     *     The SecurityContextConstraints
     */
    @JsonProperty("SecurityContextConstraints")
    public void setSecurityContextConstraints(SecurityContextConstraints securityContextConstraints) {
        this.securityContextConstraints = securityContextConstraints;
    }

    /**
     * 
     * 
     * @return
     *     The securityContextConstraintsList
     */
    @JsonProperty("SecurityContextConstraintsList")
    public SecurityContextConstraintsList getSecurityContextConstraintsList() {
        return securityContextConstraintsList;
    }

    /**
     * 
     * 
     * @param securityContextConstraintsList
     *     The SecurityContextConstraintsList
     */
    @JsonProperty("SecurityContextConstraintsList")
    public void setSecurityContextConstraintsList(SecurityContextConstraintsList securityContextConstraintsList) {
        this.securityContextConstraintsList = securityContextConstraintsList;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccount
     */
    @JsonProperty("ServiceAccount")
    public ServiceAccount getServiceAccount() {
        return serviceAccount;
    }

    /**
     * 
     * 
     * @param serviceAccount
     *     The ServiceAccount
     */
    @JsonProperty("ServiceAccount")
    public void setServiceAccount(ServiceAccount serviceAccount) {
        this.serviceAccount = serviceAccount;
    }

    /**
     * 
     * 
     * @return
     *     The serviceAccountList
     */
    @JsonProperty("ServiceAccountList")
    public ServiceAccountList getServiceAccountList() {
        return serviceAccountList;
    }

    /**
     * 
     * 
     * @param serviceAccountList
     *     The ServiceAccountList
     */
    @JsonProperty("ServiceAccountList")
    public void setServiceAccountList(ServiceAccountList serviceAccountList) {
        this.serviceAccountList = serviceAccountList;
    }

    /**
     * 
     * 
     * @return
     *     The serviceList
     */
    @JsonProperty("ServiceList")
    public ServiceList getServiceList() {
        return serviceList;
    }

    /**
     * 
     * 
     * @param serviceList
     *     The ServiceList
     */
    @JsonProperty("ServiceList")
    public void setServiceList(ServiceList serviceList) {
        this.serviceList = serviceList;
    }

    /**
     * 
     * 
     * @return
     *     The statefulSet
     */
    @JsonProperty("StatefulSet")
    public StatefulSet getStatefulSet() {
        return statefulSet;
    }

    /**
     * 
     * 
     * @param statefulSet
     *     The StatefulSet
     */
    @JsonProperty("StatefulSet")
    public void setStatefulSet(StatefulSet statefulSet) {
        this.statefulSet = statefulSet;
    }

    /**
     * 
     * 
     * @return
     *     The statefulSetList
     */
    @JsonProperty("StatefulSetList")
    public StatefulSetList getStatefulSetList() {
        return statefulSetList;
    }

    /**
     * 
     * 
     * @param statefulSetList
     *     The StatefulSetList
     */
    @JsonProperty("StatefulSetList")
    public void setStatefulSetList(StatefulSetList statefulSetList) {
        this.statefulSetList = statefulSetList;
    }

    /**
     * 
     * 
     * @return
     *     The status
     */
    @JsonProperty("Status")
    public Status getStatus() {
        return status;
    }

    /**
     * 
     * 
     * @param status
     *     The Status
     */
    @JsonProperty("Status")
    public void setStatus(Status status) {
        this.status = status;
    }

    /**
     * 
     * 
     * @return
     *     The subjectAccessReview
     */
    @JsonProperty("SubjectAccessReview")
    public SubjectAccessReview getSubjectAccessReview() {
        return subjectAccessReview;
    }

    /**
     * 
     * 
     * @param subjectAccessReview
     *     The SubjectAccessReview
     */
    @JsonProperty("SubjectAccessReview")
    public void setSubjectAccessReview(SubjectAccessReview subjectAccessReview) {
        this.subjectAccessReview = subjectAccessReview;
    }

    /**
     * 
     * 
     * @return
     *     The subjectAccessReviewResponse
     */
    @JsonProperty("SubjectAccessReviewResponse")
    public SubjectAccessReviewResponse getSubjectAccessReviewResponse() {
        return subjectAccessReviewResponse;
    }

    /**
     * 
     * 
     * @param subjectAccessReviewResponse
     *     The SubjectAccessReviewResponse
     */
    @JsonProperty("SubjectAccessReviewResponse")
    public void setSubjectAccessReviewResponse(SubjectAccessReviewResponse subjectAccessReviewResponse) {
        this.subjectAccessReviewResponse = subjectAccessReviewResponse;
    }

    /**
     * 
     * 
     * @return
     *     The tagEvent
     */
    @JsonProperty("TagEvent")
    public TagEvent getTagEvent() {
        return tagEvent;
    }

    /**
     * 
     * 
     * @param tagEvent
     *     The TagEvent
     */
    @JsonProperty("TagEvent")
    public void setTagEvent(TagEvent tagEvent) {
        this.tagEvent = tagEvent;
    }

    /**
     * 
     * 
     * @return
     *     The template
     */
    @JsonProperty("Template")
    public Template getTemplate() {
        return template;
    }

    /**
     * 
     * 
     * @param template
     *     The Template
     */
    @JsonProperty("Template")
    public void setTemplate(Template template) {
        this.template = template;
    }

    /**
     * 
     * 
     * @return
     *     The templateList
     */
    @JsonProperty("TemplateList")
    public TemplateList getTemplateList() {
        return templateList;
    }

    /**
     * 
     * 
     * @param templateList
     *     The TemplateList
     */
    @JsonProperty("TemplateList")
    public void setTemplateList(TemplateList templateList) {
        this.templateList = templateList;
    }

    /**
     * 
     * 
     * @return
     *     The thirdPartyResource
     */
    @JsonProperty("ThirdPartyResource")
    public ThirdPartyResource getThirdPartyResource() {
        return thirdPartyResource;
    }

    /**
     * 
     * 
     * @param thirdPartyResource
     *     The ThirdPartyResource
     */
    @JsonProperty("ThirdPartyResource")
    public void setThirdPartyResource(ThirdPartyResource thirdPartyResource) {
        this.thirdPartyResource = thirdPartyResource;
    }

    /**
     * 
     * 
     * @return
     *     The thirdPartyResourceList
     */
    @JsonProperty("ThirdPartyResourceList")
    public ThirdPartyResourceList getThirdPartyResourceList() {
        return thirdPartyResourceList;
    }

    /**
     * 
     * 
     * @param thirdPartyResourceList
     *     The ThirdPartyResourceList
     */
    @JsonProperty("ThirdPartyResourceList")
    public void setThirdPartyResourceList(ThirdPartyResourceList thirdPartyResourceList) {
        this.thirdPartyResourceList = thirdPartyResourceList;
    }

    /**
     * 
     * 
     * @return
     *     The user
     */
    @JsonProperty("User")
    public User getUser() {
        return user;
    }

    /**
     * 
     * 
     * @param user
     *     The User
     */
    @JsonProperty("User")
    public void setUser(User user) {
        this.user = user;
    }

    /**
     * 
     * 
     * @return
     *     The userList
     */
    @JsonProperty("UserList")
    public UserList getUserList() {
        return userList;
    }

    /**
     * 
     * 
     * @param userList
     *     The UserList
     */
    @JsonProperty("UserList")
    public void setUserList(UserList userList) {
        this.userList = userList;
    }

    /**
     * 
     * 
     * @return
     *     The watchEvent
     */
    @JsonProperty("WatchEvent")
    public WatchEvent getWatchEvent() {
        return watchEvent;
    }

    /**
     * 
     * 
     * @param watchEvent
     *     The WatchEvent
     */
    @JsonProperty("WatchEvent")
    public void setWatchEvent(WatchEvent watchEvent) {
        this.watchEvent = watchEvent;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
