package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class NetworkPolicyPortFluentImpl<A extends NetworkPolicyPortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NetworkPolicyPortFluent<A>{

    private Integer port;
    private String protocol;

    public NetworkPolicyPortFluentImpl(){
    }
    public NetworkPolicyPortFluentImpl(NetworkPolicyPort instance){
            this.withPort(instance.getPort()); 
            this.withProtocol(instance.getProtocol()); 
    }

    public Integer getPort(){
            return this.port;
    }

    public A withPort(Integer port){
            this.port=port; return (A) this;
    }

    public Boolean hasPort(){
            return this.port!=null;
    }

    public String getProtocol(){
            return this.protocol;
    }

    public A withProtocol(String protocol){
            this.protocol=protocol; return (A) this;
    }

    public Boolean hasProtocol(){
            return this.protocol!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkPolicyPortFluentImpl that = (NetworkPolicyPortFluentImpl) o;
            if (port != null ? !port.equals(that.port) :that.port != null) return false;
            if (protocol != null ? !protocol.equals(that.protocol) :that.protocol != null) return false;
            return true;
    }




}
