package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TimeBuilder extends TimeFluentImpl<TimeBuilder> implements VisitableBuilder<Time,TimeBuilder>{

    TimeFluent<?> fluent;
    Boolean validationEnabled;

    public TimeBuilder(){
            this(true);
    }
    public TimeBuilder(Boolean validationEnabled){
            this(new Time(), validationEnabled);
    }
    public TimeBuilder(TimeFluent<?> fluent){
            this(fluent, true);
    }
    public TimeBuilder(TimeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Time(), validationEnabled);
    }
    public TimeBuilder(TimeFluent<?> fluent,Time instance){
            this(fluent, instance, true);
    }
    public TimeBuilder(TimeFluent<?> fluent,Time instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withTime(instance.getTime()); 
            this.validationEnabled = validationEnabled; 
    }
    public TimeBuilder(Time instance){
            this(instance,true);
    }
    public TimeBuilder(Time instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withTime(instance.getTime()); 
            this.validationEnabled = validationEnabled; 
    }

    public Time build(){
            Time buildable = new Time(fluent.getTime());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TimeBuilder that = (TimeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
