package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ThirdPartyResourceFluent<A extends ThirdPartyResourceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getDescription();
    public A withDescription(String description);
    public Boolean hasDescription();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadata();
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ThirdPartyResourceFluent.MetadataNested<A> editMetadata();
    public ThirdPartyResourceFluent.MetadataNested<A> editOrNewMetadata();
    public ThirdPartyResourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToVersions(int index,APIVersion item);
    public A setToVersions(int index,APIVersion item);
    public A addToVersions(APIVersion... items);
    public A addAllToVersions(Collection<APIVersion> items);
    public A removeFromVersions(APIVersion... items);
    public A removeAllFromVersions(Collection<APIVersion> items);
    
/**
 * This method has been deprecated, please use method buildVersions instead.
 */
@Deprecated public List<APIVersion> getVersions();
    public List<APIVersion> buildVersions();
    public APIVersion buildVersion(int index);
    public APIVersion buildFirstVersion();
    public APIVersion buildLastVersion();
    public APIVersion buildMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<APIVersionBuilder> predicate);
    public A withVersions(List<APIVersion> versions);
    public A withVersions(APIVersion... versions);
    public Boolean hasVersions();
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersion();
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersionLike(APIVersion item);
    public ThirdPartyResourceFluent.VersionsNested<A> setNewVersionLike(int index,APIVersion item);
    public ThirdPartyResourceFluent.VersionsNested<A> editVersion(int index);
    public ThirdPartyResourceFluent.VersionsNested<A> editFirstVersion();
    public ThirdPartyResourceFluent.VersionsNested<A> editLastVersion();
    public ThirdPartyResourceFluent.VersionsNested<A> editMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<APIVersionBuilder> predicate);
    public A addNewVersion(String name);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ThirdPartyResourceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface VersionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,APIVersionFluent<ThirdPartyResourceFluent.VersionsNested<N>>{

        
    public N and();    public N endVersion();
}


}
