
package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import javax.validation.Valid;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "genericWebHook",
    "githubWebHook",
    "imageChangeBuild",
    "message"
})
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = true, generateBuilderPackage = true, builderPackage = "io.fabric8.kubernetes.api.builder", inline = @Inline(type = Doneable.class, prefix = "Doneable", value = "done"))
public class BuildTriggerCause implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("genericWebHook")
    @Valid
    private GenericWebHookCause genericWebHook;
    /**
     * 
     * 
     */
    @JsonProperty("githubWebHook")
    @Valid
    private GitHubWebHookCause githubWebHook;
    /**
     * 
     * 
     */
    @JsonProperty("imageChangeBuild")
    @Valid
    private ImageChangeCause imageChangeBuild;
    /**
     * 
     * 
     */
    @JsonProperty("message")
    private String message;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public BuildTriggerCause() {
    }

    /**
     * 
     * @param githubWebHook
     * @param genericWebHook
     * @param imageChangeBuild
     * @param message
     */
    public BuildTriggerCause(GenericWebHookCause genericWebHook, GitHubWebHookCause githubWebHook, ImageChangeCause imageChangeBuild, String message) {
        this.genericWebHook = genericWebHook;
        this.githubWebHook = githubWebHook;
        this.imageChangeBuild = imageChangeBuild;
        this.message = message;
    }

    /**
     * 
     * 
     * @return
     *     The genericWebHook
     */
    @JsonProperty("genericWebHook")
    public GenericWebHookCause getGenericWebHook() {
        return genericWebHook;
    }

    /**
     * 
     * 
     * @param genericWebHook
     *     The genericWebHook
     */
    @JsonProperty("genericWebHook")
    public void setGenericWebHook(GenericWebHookCause genericWebHook) {
        this.genericWebHook = genericWebHook;
    }

    /**
     * 
     * 
     * @return
     *     The githubWebHook
     */
    @JsonProperty("githubWebHook")
    public GitHubWebHookCause getGithubWebHook() {
        return githubWebHook;
    }

    /**
     * 
     * 
     * @param githubWebHook
     *     The githubWebHook
     */
    @JsonProperty("githubWebHook")
    public void setGithubWebHook(GitHubWebHookCause githubWebHook) {
        this.githubWebHook = githubWebHook;
    }

    /**
     * 
     * 
     * @return
     *     The imageChangeBuild
     */
    @JsonProperty("imageChangeBuild")
    public ImageChangeCause getImageChangeBuild() {
        return imageChangeBuild;
    }

    /**
     * 
     * 
     * @param imageChangeBuild
     *     The imageChangeBuild
     */
    @JsonProperty("imageChangeBuild")
    public void setImageChangeBuild(ImageChangeCause imageChangeBuild) {
        this.imageChangeBuild = imageChangeBuild;
    }

    /**
     * 
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * 
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
