package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface NodeSpecFluent<A extends NodeSpecFluent<A>> extends Fluent<A>{


    public String getExternalID();
    public A withExternalID(String externalID);
    public Boolean hasExternalID();
    public String getPodCIDR();
    public A withPodCIDR(String podCIDR);
    public Boolean hasPodCIDR();
    public String getProviderID();
    public A withProviderID(String providerID);
    public Boolean hasProviderID();
    public Boolean isUnschedulable();
    public A withUnschedulable(Boolean unschedulable);
    public Boolean hasUnschedulable();



}
