package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface ContainerStateTerminatedFluent<A extends ContainerStateTerminatedFluent<A>> extends Fluent<A>{


    public String getContainerID();
    public A withContainerID(String containerID);
    public Boolean hasContainerID();
    public Integer getExitCode();
    public A withExitCode(Integer exitCode);
    public Boolean hasExitCode();
    
/**
 * This method has been deprecated, please use method buildFinishedAt instead.
 */
@Deprecated public Time getFinishedAt();
    public Time buildFinishedAt();
    public A withFinishedAt(Time finishedAt);
    public Boolean hasFinishedAt();
    public ContainerStateTerminatedFluent.FinishedAtNested<A> withNewFinishedAt();
    public ContainerStateTerminatedFluent.FinishedAtNested<A> withNewFinishedAtLike(Time item);
    public ContainerStateTerminatedFluent.FinishedAtNested<A> editFinishedAt();
    public ContainerStateTerminatedFluent.FinishedAtNested<A> editOrNewFinishedAt();
    public ContainerStateTerminatedFluent.FinishedAtNested<A> editOrNewFinishedAtLike(Time item);
    public A withNewFinishedAt(String time);
    public String getMessage();
    public A withMessage(String message);
    public Boolean hasMessage();
    public String getReason();
    public A withReason(String reason);
    public Boolean hasReason();
    public Integer getSignal();
    public A withSignal(Integer signal);
    public Boolean hasSignal();
    
/**
 * This method has been deprecated, please use method buildStartedAt instead.
 */
@Deprecated public Time getStartedAt();
    public Time buildStartedAt();
    public A withStartedAt(Time startedAt);
    public Boolean hasStartedAt();
    public ContainerStateTerminatedFluent.StartedAtNested<A> withNewStartedAt();
    public ContainerStateTerminatedFluent.StartedAtNested<A> withNewStartedAtLike(Time item);
    public ContainerStateTerminatedFluent.StartedAtNested<A> editStartedAt();
    public ContainerStateTerminatedFluent.StartedAtNested<A> editOrNewStartedAt();
    public ContainerStateTerminatedFluent.StartedAtNested<A> editOrNewStartedAtLike(Time item);
    public A withNewStartedAt(String time);

    public interface FinishedAtNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<ContainerStateTerminatedFluent.FinishedAtNested<N>>{

        
    public N and();    public N endFinishedAt();
}
    public interface StartedAtNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<ContainerStateTerminatedFluent.StartedAtNested<N>>{

        
    public N and();    public N endStartedAt();
}


}
