package io.fabric8.kubernetes.api.model.extensions;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class StatefulSetStatusFluentImpl<A extends StatefulSetStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StatefulSetStatusFluent<A>{

    private Integer currentReplicas;
    private String currentRevision;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private String updateRevision;
    private Integer updatedReplicas;

    public StatefulSetStatusFluentImpl(){
    }
    public StatefulSetStatusFluentImpl(StatefulSetStatus instance){
            this.withCurrentReplicas(instance.getCurrentReplicas()); 
            this.withCurrentRevision(instance.getCurrentRevision()); 
            this.withObservedGeneration(instance.getObservedGeneration()); 
            this.withReadyReplicas(instance.getReadyReplicas()); 
            this.withReplicas(instance.getReplicas()); 
            this.withUpdateRevision(instance.getUpdateRevision()); 
            this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    }

    public Integer getCurrentReplicas(){
            return this.currentReplicas;
    }

    public A withCurrentReplicas(Integer currentReplicas){
            this.currentReplicas=currentReplicas; return (A) this;
    }

    public Boolean hasCurrentReplicas(){
            return this.currentReplicas!=null;
    }

    public String getCurrentRevision(){
            return this.currentRevision;
    }

    public A withCurrentRevision(String currentRevision){
            this.currentRevision=currentRevision; return (A) this;
    }

    public Boolean hasCurrentRevision(){
            return this.currentRevision!=null;
    }

    public Long getObservedGeneration(){
            return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration){
            this.observedGeneration=observedGeneration; return (A) this;
    }

    public Boolean hasObservedGeneration(){
            return this.observedGeneration!=null;
    }

    public Integer getReadyReplicas(){
            return this.readyReplicas;
    }

    public A withReadyReplicas(Integer readyReplicas){
            this.readyReplicas=readyReplicas; return (A) this;
    }

    public Boolean hasReadyReplicas(){
            return this.readyReplicas!=null;
    }

    public Integer getReplicas(){
            return this.replicas;
    }

    public A withReplicas(Integer replicas){
            this.replicas=replicas; return (A) this;
    }

    public Boolean hasReplicas(){
            return this.replicas!=null;
    }

    public String getUpdateRevision(){
            return this.updateRevision;
    }

    public A withUpdateRevision(String updateRevision){
            this.updateRevision=updateRevision; return (A) this;
    }

    public Boolean hasUpdateRevision(){
            return this.updateRevision!=null;
    }

    public Integer getUpdatedReplicas(){
            return this.updatedReplicas;
    }

    public A withUpdatedReplicas(Integer updatedReplicas){
            this.updatedReplicas=updatedReplicas; return (A) this;
    }

    public Boolean hasUpdatedReplicas(){
            return this.updatedReplicas!=null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StatefulSetStatusFluentImpl that = (StatefulSetStatusFluentImpl) o;
            if (currentReplicas != null ? !currentReplicas.equals(that.currentReplicas) :that.currentReplicas != null) return false;
            if (currentRevision != null ? !currentRevision.equals(that.currentRevision) :that.currentRevision != null) return false;
            if (observedGeneration != null ? !observedGeneration.equals(that.observedGeneration) :that.observedGeneration != null) return false;
            if (readyReplicas != null ? !readyReplicas.equals(that.readyReplicas) :that.readyReplicas != null) return false;
            if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
            if (updateRevision != null ? !updateRevision.equals(that.updateRevision) :that.updateRevision != null) return false;
            if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
            return true;
    }




}
