/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerStatus;
import io.fabric8.kubernetes.api.model.HorizontalPodAutoscalerStatusFluent;
import io.fabric8.kubernetes.api.model.Time;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluentImpl;

public class HorizontalPodAutoscalerStatusFluentImpl<A extends HorizontalPodAutoscalerStatusFluent<A>>
extends BaseFluent<A>
implements HorizontalPodAutoscalerStatusFluent<A> {
    private Integer currentCPUUtilizationPercentage;
    private Integer currentReplicas;
    private Integer desiredReplicas;
    private TimeBuilder lastScaleTime;
    private Long observedGeneration;

    public HorizontalPodAutoscalerStatusFluentImpl() {
    }

    public HorizontalPodAutoscalerStatusFluentImpl(HorizontalPodAutoscalerStatus instance) {
        this.withCurrentCPUUtilizationPercentage(instance.getCurrentCPUUtilizationPercentage());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withDesiredReplicas(instance.getDesiredReplicas());
        this.withLastScaleTime(instance.getLastScaleTime());
        this.withObservedGeneration(instance.getObservedGeneration());
    }

    @Override
    public Integer getCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage;
    }

    @Override
    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage) {
        this.currentCPUUtilizationPercentage = currentCPUUtilizationPercentage;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentCPUUtilizationPercentage() {
        return this.currentCPUUtilizationPercentage != null;
    }

    @Override
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    @Override
    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    @Override
    public Integer getDesiredReplicas() {
        return this.desiredReplicas;
    }

    @Override
    public A withDesiredReplicas(Integer desiredReplicas) {
        this.desiredReplicas = desiredReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasDesiredReplicas() {
        return this.desiredReplicas != null;
    }

    @Override
    @Deprecated
    public Time getLastScaleTime() {
        return this.lastScaleTime != null ? this.lastScaleTime.build() : null;
    }

    @Override
    public Time buildLastScaleTime() {
        return this.lastScaleTime != null ? this.lastScaleTime.build() : null;
    }

    @Override
    public A withLastScaleTime(Time lastScaleTime) {
        this._visitables.remove(this.lastScaleTime);
        if (lastScaleTime != null) {
            this.lastScaleTime = new TimeBuilder(lastScaleTime);
            this._visitables.add(this.lastScaleTime);
        }
        return (A)this;
    }

    @Override
    public Boolean hasLastScaleTime() {
        return this.lastScaleTime != null;
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> withNewLastScaleTime() {
        return new LastScaleTimeNestedImpl();
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> withNewLastScaleTimeLike(Time item) {
        return new LastScaleTimeNestedImpl(item);
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> editLastScaleTime() {
        return this.withNewLastScaleTimeLike(this.getLastScaleTime());
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> editOrNewLastScaleTime() {
        return this.withNewLastScaleTimeLike(this.getLastScaleTime() != null ? this.getLastScaleTime() : new TimeBuilder().build());
    }

    @Override
    public HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<A> editOrNewLastScaleTimeLike(Time item) {
        return this.withNewLastScaleTimeLike(this.getLastScaleTime() != null ? this.getLastScaleTime() : item);
    }

    @Override
    public A withNewLastScaleTime(String time) {
        return this.withLastScaleTime(new Time(time));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HorizontalPodAutoscalerStatusFluentImpl that = (HorizontalPodAutoscalerStatusFluentImpl)o;
        if (this.currentCPUUtilizationPercentage != null ? !this.currentCPUUtilizationPercentage.equals(that.currentCPUUtilizationPercentage) : that.currentCPUUtilizationPercentage != null) {
            return false;
        }
        if (this.currentReplicas != null ? !this.currentReplicas.equals(that.currentReplicas) : that.currentReplicas != null) {
            return false;
        }
        if (this.desiredReplicas != null ? !this.desiredReplicas.equals(that.desiredReplicas) : that.desiredReplicas != null) {
            return false;
        }
        if (this.lastScaleTime != null ? !this.lastScaleTime.equals(that.lastScaleTime) : that.lastScaleTime != null) {
            return false;
        }
        return !(this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null);
    }

    public class LastScaleTimeNestedImpl<N>
    extends TimeFluentImpl<HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<N>>
    implements HorizontalPodAutoscalerStatusFluent.LastScaleTimeNested<N>,
    Nested<N> {
        private final TimeBuilder builder;

        LastScaleTimeNestedImpl(Time item) {
            this.builder = new TimeBuilder(this, item);
        }

        LastScaleTimeNestedImpl() {
            this.builder = new TimeBuilder(this);
        }

        @Override
        public N and() {
            return (N)HorizontalPodAutoscalerStatusFluentImpl.this.withLastScaleTime(this.builder.build());
        }

        @Override
        public N endLastScaleTime() {
            return this.and();
        }
    }
}

