package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class NodeSelectorTermFluentImpl<A extends NodeSelectorTermFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeSelectorTermFluent<A>{

    private List<NodeSelectorRequirementBuilder> matchExpressions =  new ArrayList<NodeSelectorRequirementBuilder>();

    public NodeSelectorTermFluentImpl(){
    }
    public NodeSelectorTermFluentImpl(NodeSelectorTerm instance){
            this.withMatchExpressions(instance.getMatchExpressions()); 
    }

    public A addToMatchExpressions(int index,NodeSelectorRequirement item){
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.matchExpressions.add(index >= 0 ? index : matchExpressions.size(), builder); return (A)this;
    }

    public A setToMatchExpressions(int index,NodeSelectorRequirement item){
            NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= matchExpressions.size()) { matchExpressions.add(builder); } else { matchExpressions.set(index, builder);}
             return (A)this;
    }

    public A addToMatchExpressions(NodeSelectorRequirement... items){
            for (NodeSelectorRequirement item : items) {NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);_visitables.add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A addAllToMatchExpressions(Collection<NodeSelectorRequirement> items){
            for (NodeSelectorRequirement item : items) {NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);_visitables.add(builder);this.matchExpressions.add(builder);} return (A)this;
    }

    public A removeFromMatchExpressions(NodeSelectorRequirement... items){
            for (NodeSelectorRequirement item : items) {NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);_visitables.remove(builder);this.matchExpressions.remove(builder);} return (A)this;
    }

    public A removeAllFromMatchExpressions(Collection<NodeSelectorRequirement> items){
            for (NodeSelectorRequirement item : items) {NodeSelectorRequirementBuilder builder = new NodeSelectorRequirementBuilder(item);_visitables.remove(builder);this.matchExpressions.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMatchExpressions instead.
 */
@Deprecated public List<NodeSelectorRequirement> getMatchExpressions(){
            return build(matchExpressions);
    }

    public List<NodeSelectorRequirement> buildMatchExpressions(){
            return build(matchExpressions);
    }

    public NodeSelectorRequirement buildMatchExpression(int index){
            return this.matchExpressions.get(index).build();
    }

    public NodeSelectorRequirement buildFirstMatchExpression(){
            return this.matchExpressions.get(0).build();
    }

    public NodeSelectorRequirement buildLastMatchExpression(){
            return this.matchExpressions.get(matchExpressions.size() - 1).build();
    }

    public NodeSelectorRequirement buildMatchingMatchExpression(io.fabric8.kubernetes.api.builder.Predicate<NodeSelectorRequirementBuilder> predicate){
            for (NodeSelectorRequirementBuilder item: matchExpressions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withMatchExpressions(List<NodeSelectorRequirement> matchExpressions){
            _visitables.removeAll(this.matchExpressions);
            this.matchExpressions.clear();
            if (matchExpressions != null) {for (NodeSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} return (A) this;
    }

    public A withMatchExpressions(NodeSelectorRequirement... matchExpressions){
            this.matchExpressions.clear(); if (matchExpressions != null) {for (NodeSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (A) this;
    }

    public Boolean hasMatchExpressions(){
            return matchExpressions!= null && !matchExpressions.isEmpty();
    }

    public NodeSelectorTermFluent.MatchExpressionsNested<A> addNewMatchExpression(){
            return new MatchExpressionsNestedImpl();
    }

    public NodeSelectorTermFluent.MatchExpressionsNested<A> addNewMatchExpressionLike(NodeSelectorRequirement item){
            return new MatchExpressionsNestedImpl(-1, item);
    }

    public NodeSelectorTermFluent.MatchExpressionsNested<A> setNewMatchExpressionLike(int index,NodeSelectorRequirement item){
            return new MatchExpressionsNestedImpl(index, item);
    }

    public NodeSelectorTermFluent.MatchExpressionsNested<A> editMatchExpression(int index){
            if (matchExpressions.size() <= index) throw new RuntimeException("Can't edit matchExpressions. Index exceeds size.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public NodeSelectorTermFluent.MatchExpressionsNested<A> editFirstMatchExpression(){
            if (matchExpressions.size() == 0) throw new RuntimeException("Can't edit first matchExpressions. The list is empty.");
            return setNewMatchExpressionLike(0, buildMatchExpression(0));
    }

    public NodeSelectorTermFluent.MatchExpressionsNested<A> editLastMatchExpression(){
            int index = matchExpressions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last matchExpressions. The list is empty.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public NodeSelectorTermFluent.MatchExpressionsNested<A> editMatchingMatchExpression(io.fabric8.kubernetes.api.builder.Predicate<NodeSelectorRequirementBuilder> predicate){
            int index = -1;
            for (int i=0;i<matchExpressions.size();i++) { 
            if (predicate.apply(matchExpressions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching matchExpressions. No match found.");
            return setNewMatchExpressionLike(index, buildMatchExpression(index));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeSelectorTermFluentImpl that = (NodeSelectorTermFluentImpl) o;
            if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
            return true;
    }


    public class MatchExpressionsNestedImpl<N> extends NodeSelectorRequirementFluentImpl<NodeSelectorTermFluent.MatchExpressionsNested<N>> implements NodeSelectorTermFluent.MatchExpressionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final NodeSelectorRequirementBuilder builder;
        private final int index;
    
            MatchExpressionsNestedImpl(int index,NodeSelectorRequirement item){
                    this.index = index;
                    this.builder = new NodeSelectorRequirementBuilder(this, item);
            }
            MatchExpressionsNestedImpl(){
                    this.index = -1;
                    this.builder = new NodeSelectorRequirementBuilder(this);
            }
    
    public N and(){
            return (N) NodeSelectorTermFluentImpl.this.setToMatchExpressions(index, builder.build());
    }
    public N endMatchExpression(){
            return and();
    }

}


}
