package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Time;
import java.lang.String;
import io.fabric8.kubernetes.api.model.TimeBuilder;
import io.fabric8.kubernetes.api.model.TimeFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface StepInfoFluent<A extends StepInfoFluent<A>> extends Fluent<A>{


    public Long getDurationMilliseconds();
    public A withDurationMilliseconds(Long durationMilliseconds);
    public Boolean hasDurationMilliseconds();
    public String getName();
    public A withName(String name);
    public Boolean hasName();
    
/**
 * This method has been deprecated, please use method buildStartTime instead.
 */
@Deprecated public Time getStartTime();
    public Time buildStartTime();
    public A withStartTime(Time startTime);
    public Boolean hasStartTime();
    public StepInfoFluent.StartTimeNested<A> withNewStartTime();
    public StepInfoFluent.StartTimeNested<A> withNewStartTimeLike(Time item);
    public StepInfoFluent.StartTimeNested<A> editStartTime();
    public StepInfoFluent.StartTimeNested<A> editOrNewStartTime();
    public StepInfoFluent.StartTimeNested<A> editOrNewStartTimeLike(Time item);
    public A withNewStartTime(String time);

    public interface StartTimeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,TimeFluent<StepInfoFluent.StartTimeNested<N>>{

        
    public N and();    public N endStartTime();
}


}
