package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface NetworkPolicySpecFluent<A extends NetworkPolicySpecFluent<A>> extends Fluent<A>{


    public A addToIngress(int index,NetworkPolicyIngressRule item);
    public A setToIngress(int index,NetworkPolicyIngressRule item);
    public A addToIngress(NetworkPolicyIngressRule... items);
    public A addAllToIngress(Collection<NetworkPolicyIngressRule> items);
    public A removeFromIngress(NetworkPolicyIngressRule... items);
    public A removeAllFromIngress(Collection<NetworkPolicyIngressRule> items);
    
/**
 * This method has been deprecated, please use method buildIngress instead.
 */
@Deprecated public List<NetworkPolicyIngressRule> getIngress();
    public List<NetworkPolicyIngressRule> buildIngress();
    public NetworkPolicyIngressRule buildIngress(int index);
    public NetworkPolicyIngressRule buildFirstIngress();
    public NetworkPolicyIngressRule buildLastIngress();
    public NetworkPolicyIngressRule buildMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyIngressRuleBuilder> predicate);
    public A withIngress(List<NetworkPolicyIngressRule> ingress);
    public A withIngress(NetworkPolicyIngressRule... ingress);
    public Boolean hasIngress();
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngress();
    public NetworkPolicySpecFluent.IngressNested<A> addNewIngressLike(NetworkPolicyIngressRule item);
    public NetworkPolicySpecFluent.IngressNested<A> setNewIngressLike(int index,NetworkPolicyIngressRule item);
    public NetworkPolicySpecFluent.IngressNested<A> editIngress(int index);
    public NetworkPolicySpecFluent.IngressNested<A> editFirstIngress();
    public NetworkPolicySpecFluent.IngressNested<A> editLastIngress();
    public NetworkPolicySpecFluent.IngressNested<A> editMatchingIngress(io.fabric8.kubernetes.api.builder.Predicate<NetworkPolicyIngressRuleBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPodSelector instead.
 */
@Deprecated public LabelSelector getPodSelector();
    public LabelSelector buildPodSelector();
    public A withPodSelector(LabelSelector podSelector);
    public Boolean hasPodSelector();
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelector();
    public NetworkPolicySpecFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item);
    public NetworkPolicySpecFluent.PodSelectorNested<A> editPodSelector();
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelector();
    public NetworkPolicySpecFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item);

    public interface IngressNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NetworkPolicyIngressRuleFluent<NetworkPolicySpecFluent.IngressNested<N>>{

        
    public N and();    public N endIngress();
}
    public interface PodSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<NetworkPolicySpecFluent.PodSelectorNested<N>>{

        
    public N and();    public N endPodSelector();
}


}
