package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkPolicyPeerFluentImpl<A extends NetworkPolicyPeerFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NetworkPolicyPeerFluent<A>{

    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder podSelector;

    public NetworkPolicyPeerFluentImpl(){
    }
    public NetworkPolicyPeerFluentImpl(NetworkPolicyPeer instance){
            this.withNamespaceSelector(instance.getNamespaceSelector()); 
            this.withPodSelector(instance.getPodSelector()); 
    }

    
/**
 * This method has been deprecated, please use method buildNamespaceSelector instead.
 */
@Deprecated public LabelSelector getNamespaceSelector(){
            return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public LabelSelector buildNamespaceSelector(){
            return this.namespaceSelector!=null?this.namespaceSelector.build():null;
    }

    public A withNamespaceSelector(LabelSelector namespaceSelector){
            _visitables.remove(this.namespaceSelector);
            if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.add(this.namespaceSelector);} return (A) this;
    }

    public Boolean hasNamespaceSelector(){
            return this.namespaceSelector!=null;
    }

    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelector(){
            return new NamespaceSelectorNestedImpl();
    }

    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item){
            return new NamespaceSelectorNestedImpl(item);
    }

    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editNamespaceSelector(){
            return withNewNamespaceSelectorLike(getNamespaceSelector());
    }

    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector(){
            return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
    }

    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item){
            return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildPodSelector instead.
 */
@Deprecated public LabelSelector getPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public LabelSelector buildPodSelector(){
            return this.podSelector!=null?this.podSelector.build():null;
    }

    public A withPodSelector(LabelSelector podSelector){
            _visitables.remove(this.podSelector);
            if (podSelector!=null){ this.podSelector= new LabelSelectorBuilder(podSelector); _visitables.add(this.podSelector);} return (A) this;
    }

    public Boolean hasPodSelector(){
            return this.podSelector!=null;
    }

    public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelector(){
            return new PodSelectorNestedImpl();
    }

    public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item){
            return new PodSelectorNestedImpl(item);
    }

    public NetworkPolicyPeerFluent.PodSelectorNested<A> editPodSelector(){
            return withNewPodSelectorLike(getPodSelector());
    }

    public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelector(){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): new LabelSelectorBuilder().build());
    }

    public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item){
            return withNewPodSelectorLike(getPodSelector() != null ? getPodSelector(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NetworkPolicyPeerFluentImpl that = (NetworkPolicyPeerFluentImpl) o;
            if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
            if (podSelector != null ? !podSelector.equals(that.podSelector) :that.podSelector != null) return false;
            return true;
    }


    public class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.NamespaceSelectorNested<N>> implements NetworkPolicyPeerFluent.NamespaceSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LabelSelectorBuilder builder;
    
            NamespaceSelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
            NamespaceSelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) NetworkPolicyPeerFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector(){
            return and();
    }

}
    public class PodSelectorNestedImpl<N> extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.PodSelectorNested<N>> implements NetworkPolicyPeerFluent.PodSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LabelSelectorBuilder builder;
    
            PodSelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
            PodSelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) NetworkPolicyPeerFluentImpl.this.withPodSelector(builder.build());
    }
    public N endPodSelector(){
            return and();
    }

}


}
