package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubeSchemaBuilder extends KubeSchemaFluentImpl<KubeSchemaBuilder> implements VisitableBuilder<KubeSchema,KubeSchemaBuilder>{

    KubeSchemaFluent<?> fluent;
    Boolean validationEnabled;

    public KubeSchemaBuilder(){
            this(true);
    }
    public KubeSchemaBuilder(Boolean validationEnabled){
            this(new KubeSchema(), validationEnabled);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent){
            this(fluent, true);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubeSchema(), validationEnabled);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,KubeSchema instance){
            this(fluent, instance, true);
    }
    public KubeSchemaBuilder(KubeSchemaFluent<?> fluent,KubeSchema instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withBaseKubernetesList(instance.getBaseKubernetesList()); 
            fluent.withBinding(instance.getBinding()); 
            fluent.withBuildConfigList(instance.getBuildConfigList()); 
            fluent.withBuildList(instance.getBuildList()); 
            fluent.withBuildRequest(instance.getBuildRequest()); 
            fluent.withClusterPolicy(instance.getClusterPolicy()); 
            fluent.withClusterPolicyBinding(instance.getClusterPolicyBinding()); 
            fluent.withClusterPolicyBindingList(instance.getClusterPolicyBindingList()); 
            fluent.withClusterPolicyList(instance.getClusterPolicyList()); 
            fluent.withClusterRoleBinding(instance.getClusterRoleBinding()); 
            fluent.withClusterRoleBindingList(instance.getClusterRoleBindingList()); 
            fluent.withComponentStatusList(instance.getComponentStatusList()); 
            fluent.withConfig(instance.getConfig()); 
            fluent.withConfigMap(instance.getConfigMap()); 
            fluent.withConfigMapList(instance.getConfigMapList()); 
            fluent.withContainerStatus(instance.getContainerStatus()); 
            fluent.withCronJob(instance.getCronJob()); 
            fluent.withCronJobList(instance.getCronJobList()); 
            fluent.withCustomResourceDefinition(instance.getCustomResourceDefinition()); 
            fluent.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition()); 
            fluent.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList()); 
            fluent.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames()); 
            fluent.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec()); 
            fluent.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus()); 
            fluent.withDaemonSet(instance.getDaemonSet()); 
            fluent.withDaemonSetList(instance.getDaemonSetList()); 
            fluent.withDeleteOptions(instance.getDeleteOptions()); 
            fluent.withDeployment(instance.getDeployment()); 
            fluent.withDeploymentConfig(instance.getDeploymentConfig()); 
            fluent.withDeploymentConfigList(instance.getDeploymentConfigList()); 
            fluent.withDeploymentList(instance.getDeploymentList()); 
            fluent.withDeploymentRollback(instance.getDeploymentRollback()); 
            fluent.withEndpoints(instance.getEndpoints()); 
            fluent.withEndpointsList(instance.getEndpointsList()); 
            fluent.withEnvVar(instance.getEnvVar()); 
            fluent.withEventList(instance.getEventList()); 
            fluent.withGroup(instance.getGroup()); 
            fluent.withGroupList(instance.getGroupList()); 
            fluent.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler()); 
            fluent.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList()); 
            fluent.withIdentity(instance.getIdentity()); 
            fluent.withIdentityList(instance.getIdentityList()); 
            fluent.withImageList(instance.getImageList()); 
            fluent.withImageStreamList(instance.getImageStreamList()); 
            fluent.withImageStreamTagList(instance.getImageStreamTagList()); 
            fluent.withIngress(instance.getIngress()); 
            fluent.withIngressList(instance.getIngressList()); 
            fluent.withJob(instance.getJob()); 
            fluent.withJobList(instance.getJobList()); 
            fluent.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview()); 
            fluent.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview()); 
            fluent.withLimitRangeList(instance.getLimitRangeList()); 
            fluent.withListMeta(instance.getListMeta()); 
            fluent.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview()); 
            fluent.withNamespace(instance.getNamespace()); 
            fluent.withNamespaceList(instance.getNamespaceList()); 
            fluent.withNetworkPolicy(instance.getNetworkPolicy()); 
            fluent.withNetworkPolicyList(instance.getNetworkPolicyList()); 
            fluent.withNode(instance.getNode()); 
            fluent.withNodeList(instance.getNodeList()); 
            fluent.withOAuthAccessToken(instance.getOAuthAccessToken()); 
            fluent.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); 
            fluent.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); 
            fluent.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); 
            fluent.withOAuthClient(instance.getOAuthClient()); 
            fluent.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); 
            fluent.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); 
            fluent.withOAuthClientList(instance.getOAuthClientList()); 
            fluent.withObjectMeta(instance.getObjectMeta()); 
            fluent.withPatch(instance.getPatch()); 
            fluent.withPersistentVolume(instance.getPersistentVolume()); 
            fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
            fluent.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); 
            fluent.withPersistentVolumeList(instance.getPersistentVolumeList()); 
            fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget()); 
            fluent.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList()); 
            fluent.withPodList(instance.getPodList()); 
            fluent.withPodSecurityPolicy(instance.getPodSecurityPolicy()); 
            fluent.withPodSecurityPolicyList(instance.getPodSecurityPolicyList()); 
            fluent.withPodTemplateList(instance.getPodTemplateList()); 
            fluent.withPolicy(instance.getPolicy()); 
            fluent.withPolicyBinding(instance.getPolicyBinding()); 
            fluent.withPolicyBindingList(instance.getPolicyBindingList()); 
            fluent.withPolicyList(instance.getPolicyList()); 
            fluent.withProject(instance.getProject()); 
            fluent.withProjectList(instance.getProjectList()); 
            fluent.withProjectRequest(instance.getProjectRequest()); 
            fluent.withQuantity(instance.getQuantity()); 
            fluent.withReplicaSet(instance.getReplicaSet()); 
            fluent.withReplicaSetList(instance.getReplicaSetList()); 
            fluent.withReplicationControllerList(instance.getReplicationControllerList()); 
            fluent.withResourceQuota(instance.getResourceQuota()); 
            fluent.withResourceQuotaList(instance.getResourceQuotaList()); 
            fluent.withRole(instance.getRole()); 
            fluent.withRoleBinding(instance.getRoleBinding()); 
            fluent.withRoleBindingList(instance.getRoleBindingList()); 
            fluent.withRoleBindingRestriction(instance.getRoleBindingRestriction()); 
            fluent.withRoleList(instance.getRoleList()); 
            fluent.withRootPaths(instance.getRootPaths()); 
            fluent.withRoute(instance.getRoute()); 
            fluent.withRouteList(instance.getRouteList()); 
            fluent.withScale(instance.getScale()); 
            fluent.withSecret(instance.getSecret()); 
            fluent.withSecretList(instance.getSecretList()); 
            fluent.withSecurityContextConstraints(instance.getSecurityContextConstraints()); 
            fluent.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList()); 
            fluent.withServiceAccount(instance.getServiceAccount()); 
            fluent.withServiceAccountList(instance.getServiceAccountList()); 
            fluent.withServiceList(instance.getServiceList()); 
            fluent.withStatefulSet(instance.getStatefulSet()); 
            fluent.withStatefulSetList(instance.getStatefulSetList()); 
            fluent.withStatus(instance.getStatus()); 
            fluent.withStorageClass(instance.getStorageClass()); 
            fluent.withStorageClassList(instance.getStorageClassList()); 
            fluent.withSubjectAccessReview(instance.getSubjectAccessReview()); 
            fluent.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse()); 
            fluent.withTagEvent(instance.getTagEvent()); 
            fluent.withTemplate(instance.getTemplate()); 
            fluent.withTemplateList(instance.getTemplateList()); 
            fluent.withThirdPartyResource(instance.getThirdPartyResource()); 
            fluent.withThirdPartyResourceList(instance.getThirdPartyResourceList()); 
            fluent.withTokenReview(instance.getTokenReview()); 
            fluent.withToleration(instance.getToleration()); 
            fluent.withUser(instance.getUser()); 
            fluent.withUserList(instance.getUserList()); 
            fluent.withWatchEvent(instance.getWatchEvent()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubeSchemaBuilder(KubeSchema instance){
            this(instance,true);
    }
    public KubeSchemaBuilder(KubeSchema instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withBaseKubernetesList(instance.getBaseKubernetesList()); 
            this.withBinding(instance.getBinding()); 
            this.withBuildConfigList(instance.getBuildConfigList()); 
            this.withBuildList(instance.getBuildList()); 
            this.withBuildRequest(instance.getBuildRequest()); 
            this.withClusterPolicy(instance.getClusterPolicy()); 
            this.withClusterPolicyBinding(instance.getClusterPolicyBinding()); 
            this.withClusterPolicyBindingList(instance.getClusterPolicyBindingList()); 
            this.withClusterPolicyList(instance.getClusterPolicyList()); 
            this.withClusterRoleBinding(instance.getClusterRoleBinding()); 
            this.withClusterRoleBindingList(instance.getClusterRoleBindingList()); 
            this.withComponentStatusList(instance.getComponentStatusList()); 
            this.withConfig(instance.getConfig()); 
            this.withConfigMap(instance.getConfigMap()); 
            this.withConfigMapList(instance.getConfigMapList()); 
            this.withContainerStatus(instance.getContainerStatus()); 
            this.withCronJob(instance.getCronJob()); 
            this.withCronJobList(instance.getCronJobList()); 
            this.withCustomResourceDefinition(instance.getCustomResourceDefinition()); 
            this.withCustomResourceDefinitionCondition(instance.getCustomResourceDefinitionCondition()); 
            this.withCustomResourceDefinitionList(instance.getCustomResourceDefinitionList()); 
            this.withCustomResourceDefinitionNames(instance.getCustomResourceDefinitionNames()); 
            this.withCustomResourceDefinitionSpec(instance.getCustomResourceDefinitionSpec()); 
            this.withCustomResourceDefinitionStatus(instance.getCustomResourceDefinitionStatus()); 
            this.withDaemonSet(instance.getDaemonSet()); 
            this.withDaemonSetList(instance.getDaemonSetList()); 
            this.withDeleteOptions(instance.getDeleteOptions()); 
            this.withDeployment(instance.getDeployment()); 
            this.withDeploymentConfig(instance.getDeploymentConfig()); 
            this.withDeploymentConfigList(instance.getDeploymentConfigList()); 
            this.withDeploymentList(instance.getDeploymentList()); 
            this.withDeploymentRollback(instance.getDeploymentRollback()); 
            this.withEndpoints(instance.getEndpoints()); 
            this.withEndpointsList(instance.getEndpointsList()); 
            this.withEnvVar(instance.getEnvVar()); 
            this.withEventList(instance.getEventList()); 
            this.withGroup(instance.getGroup()); 
            this.withGroupList(instance.getGroupList()); 
            this.withHorizontalPodAutoscaler(instance.getHorizontalPodAutoscaler()); 
            this.withHorizontalPodAutoscalerList(instance.getHorizontalPodAutoscalerList()); 
            this.withIdentity(instance.getIdentity()); 
            this.withIdentityList(instance.getIdentityList()); 
            this.withImageList(instance.getImageList()); 
            this.withImageStreamList(instance.getImageStreamList()); 
            this.withImageStreamTagList(instance.getImageStreamTagList()); 
            this.withIngress(instance.getIngress()); 
            this.withIngressList(instance.getIngressList()); 
            this.withJob(instance.getJob()); 
            this.withJobList(instance.getJobList()); 
            this.withK8sLocalSubjectAccessReview(instance.getK8sLocalSubjectAccessReview()); 
            this.withK8sSubjectAccessReview(instance.getK8sSubjectAccessReview()); 
            this.withLimitRangeList(instance.getLimitRangeList()); 
            this.withListMeta(instance.getListMeta()); 
            this.withLocalSubjectAccessReview(instance.getLocalSubjectAccessReview()); 
            this.withNamespace(instance.getNamespace()); 
            this.withNamespaceList(instance.getNamespaceList()); 
            this.withNetworkPolicy(instance.getNetworkPolicy()); 
            this.withNetworkPolicyList(instance.getNetworkPolicyList()); 
            this.withNode(instance.getNode()); 
            this.withNodeList(instance.getNodeList()); 
            this.withOAuthAccessToken(instance.getOAuthAccessToken()); 
            this.withOAuthAccessTokenList(instance.getOAuthAccessTokenList()); 
            this.withOAuthAuthorizeToken(instance.getOAuthAuthorizeToken()); 
            this.withOAuthAuthorizeTokenList(instance.getOAuthAuthorizeTokenList()); 
            this.withOAuthClient(instance.getOAuthClient()); 
            this.withOAuthClientAuthorization(instance.getOAuthClientAuthorization()); 
            this.withOAuthClientAuthorizationList(instance.getOAuthClientAuthorizationList()); 
            this.withOAuthClientList(instance.getOAuthClientList()); 
            this.withObjectMeta(instance.getObjectMeta()); 
            this.withPatch(instance.getPatch()); 
            this.withPersistentVolume(instance.getPersistentVolume()); 
            this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); 
            this.withPersistentVolumeClaimList(instance.getPersistentVolumeClaimList()); 
            this.withPersistentVolumeList(instance.getPersistentVolumeList()); 
            this.withPodDisruptionBudget(instance.getPodDisruptionBudget()); 
            this.withPodDisruptionBudgetList(instance.getPodDisruptionBudgetList()); 
            this.withPodList(instance.getPodList()); 
            this.withPodSecurityPolicy(instance.getPodSecurityPolicy()); 
            this.withPodSecurityPolicyList(instance.getPodSecurityPolicyList()); 
            this.withPodTemplateList(instance.getPodTemplateList()); 
            this.withPolicy(instance.getPolicy()); 
            this.withPolicyBinding(instance.getPolicyBinding()); 
            this.withPolicyBindingList(instance.getPolicyBindingList()); 
            this.withPolicyList(instance.getPolicyList()); 
            this.withProject(instance.getProject()); 
            this.withProjectList(instance.getProjectList()); 
            this.withProjectRequest(instance.getProjectRequest()); 
            this.withQuantity(instance.getQuantity()); 
            this.withReplicaSet(instance.getReplicaSet()); 
            this.withReplicaSetList(instance.getReplicaSetList()); 
            this.withReplicationControllerList(instance.getReplicationControllerList()); 
            this.withResourceQuota(instance.getResourceQuota()); 
            this.withResourceQuotaList(instance.getResourceQuotaList()); 
            this.withRole(instance.getRole()); 
            this.withRoleBinding(instance.getRoleBinding()); 
            this.withRoleBindingList(instance.getRoleBindingList()); 
            this.withRoleBindingRestriction(instance.getRoleBindingRestriction()); 
            this.withRoleList(instance.getRoleList()); 
            this.withRootPaths(instance.getRootPaths()); 
            this.withRoute(instance.getRoute()); 
            this.withRouteList(instance.getRouteList()); 
            this.withScale(instance.getScale()); 
            this.withSecret(instance.getSecret()); 
            this.withSecretList(instance.getSecretList()); 
            this.withSecurityContextConstraints(instance.getSecurityContextConstraints()); 
            this.withSecurityContextConstraintsList(instance.getSecurityContextConstraintsList()); 
            this.withServiceAccount(instance.getServiceAccount()); 
            this.withServiceAccountList(instance.getServiceAccountList()); 
            this.withServiceList(instance.getServiceList()); 
            this.withStatefulSet(instance.getStatefulSet()); 
            this.withStatefulSetList(instance.getStatefulSetList()); 
            this.withStatus(instance.getStatus()); 
            this.withStorageClass(instance.getStorageClass()); 
            this.withStorageClassList(instance.getStorageClassList()); 
            this.withSubjectAccessReview(instance.getSubjectAccessReview()); 
            this.withSubjectAccessReviewResponse(instance.getSubjectAccessReviewResponse()); 
            this.withTagEvent(instance.getTagEvent()); 
            this.withTemplate(instance.getTemplate()); 
            this.withTemplateList(instance.getTemplateList()); 
            this.withThirdPartyResource(instance.getThirdPartyResource()); 
            this.withThirdPartyResourceList(instance.getThirdPartyResourceList()); 
            this.withTokenReview(instance.getTokenReview()); 
            this.withToleration(instance.getToleration()); 
            this.withUser(instance.getUser()); 
            this.withUserList(instance.getUserList()); 
            this.withWatchEvent(instance.getWatchEvent()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubeSchema build(){
            KubeSchema buildable = new KubeSchema(fluent.getBaseKubernetesList(),fluent.getBinding(),fluent.getBuildConfigList(),fluent.getBuildList(),fluent.getBuildRequest(),fluent.getClusterPolicy(),fluent.getClusterPolicyBinding(),fluent.getClusterPolicyBindingList(),fluent.getClusterPolicyList(),fluent.getClusterRoleBinding(),fluent.getClusterRoleBindingList(),fluent.getComponentStatusList(),fluent.getConfig(),fluent.getConfigMap(),fluent.getConfigMapList(),fluent.getContainerStatus(),fluent.getCronJob(),fluent.getCronJobList(),fluent.getCustomResourceDefinition(),fluent.getCustomResourceDefinitionCondition(),fluent.getCustomResourceDefinitionList(),fluent.getCustomResourceDefinitionNames(),fluent.getCustomResourceDefinitionSpec(),fluent.getCustomResourceDefinitionStatus(),fluent.getDaemonSet(),fluent.getDaemonSetList(),fluent.getDeleteOptions(),fluent.getDeployment(),fluent.getDeploymentConfig(),fluent.getDeploymentConfigList(),fluent.getDeploymentList(),fluent.getDeploymentRollback(),fluent.getEndpoints(),fluent.getEndpointsList(),fluent.getEnvVar(),fluent.getEventList(),fluent.getGroup(),fluent.getGroupList(),fluent.getHorizontalPodAutoscaler(),fluent.getHorizontalPodAutoscalerList(),fluent.getIdentity(),fluent.getIdentityList(),fluent.getImageList(),fluent.getImageStreamList(),fluent.getImageStreamTagList(),fluent.getIngress(),fluent.getIngressList(),fluent.getJob(),fluent.getJobList(),fluent.getK8sLocalSubjectAccessReview(),fluent.getK8sSubjectAccessReview(),fluent.getLimitRangeList(),fluent.getListMeta(),fluent.getLocalSubjectAccessReview(),fluent.getNamespace(),fluent.getNamespaceList(),fluent.getNetworkPolicy(),fluent.getNetworkPolicyList(),fluent.getNode(),fluent.getNodeList(),fluent.getOAuthAccessToken(),fluent.getOAuthAccessTokenList(),fluent.getOAuthAuthorizeToken(),fluent.getOAuthAuthorizeTokenList(),fluent.getOAuthClient(),fluent.getOAuthClientAuthorization(),fluent.getOAuthClientAuthorizationList(),fluent.getOAuthClientList(),fluent.getObjectMeta(),fluent.getPatch(),fluent.getPersistentVolume(),fluent.getPersistentVolumeClaim(),fluent.getPersistentVolumeClaimList(),fluent.getPersistentVolumeList(),fluent.getPodDisruptionBudget(),fluent.getPodDisruptionBudgetList(),fluent.getPodList(),fluent.getPodSecurityPolicy(),fluent.getPodSecurityPolicyList(),fluent.getPodTemplateList(),fluent.getPolicy(),fluent.getPolicyBinding(),fluent.getPolicyBindingList(),fluent.getPolicyList(),fluent.getProject(),fluent.getProjectList(),fluent.getProjectRequest(),fluent.getQuantity(),fluent.getReplicaSet(),fluent.getReplicaSetList(),fluent.getReplicationControllerList(),fluent.getResourceQuota(),fluent.getResourceQuotaList(),fluent.getRole(),fluent.getRoleBinding(),fluent.getRoleBindingList(),fluent.getRoleBindingRestriction(),fluent.getRoleList(),fluent.getRootPaths(),fluent.getRoute(),fluent.getRouteList(),fluent.getScale(),fluent.getSecret(),fluent.getSecretList(),fluent.getSecurityContextConstraints(),fluent.getSecurityContextConstraintsList(),fluent.getServiceAccount(),fluent.getServiceAccountList(),fluent.getServiceList(),fluent.getStatefulSet(),fluent.getStatefulSetList(),fluent.getStatus(),fluent.getStorageClass(),fluent.getStorageClassList(),fluent.getSubjectAccessReview(),fluent.getSubjectAccessReviewResponse(),fluent.getTagEvent(),fluent.getTemplate(),fluent.getTemplateList(),fluent.getThirdPartyResource(),fluent.getThirdPartyResourceList(),fluent.getTokenReview(),fluent.getToleration(),fluent.getUser(),fluent.getUserList(),fluent.getWatchEvent());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubeSchemaBuilder that = (KubeSchemaBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
