package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterPolicyFluent<A extends ClusterPolicyFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public String getLastModified();
    public A withLastModified(String lastModified);
    public Boolean hasLastModified();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterPolicyFluent.MetadataNested<A> editMetadata();
    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterPolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToRoles(int index,NamedClusterRole item);
    public A setToRoles(int index,NamedClusterRole item);
    public A addToRoles(NamedClusterRole... items);
    public A addAllToRoles(Collection<NamedClusterRole> items);
    public A removeFromRoles(NamedClusterRole... items);
    public A removeAllFromRoles(Collection<NamedClusterRole> items);
    
/**
 * This method has been deprecated, please use method buildRoles instead.
 */
@Deprecated public List<NamedClusterRole> getRoles();
    public List<NamedClusterRole> buildRoles();
    public NamedClusterRole buildRole(int index);
    public NamedClusterRole buildFirstRole();
    public NamedClusterRole buildLastRole();
    public NamedClusterRole buildMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedClusterRoleBuilder> predicate);
    public A withRoles(List<NamedClusterRole> roles);
    public A withRoles(NamedClusterRole... roles);
    public Boolean hasRoles();
    public ClusterPolicyFluent.RolesNested<A> addNewRole();
    public ClusterPolicyFluent.RolesNested<A> addNewRoleLike(NamedClusterRole item);
    public ClusterPolicyFluent.RolesNested<A> setNewRoleLike(int index,NamedClusterRole item);
    public ClusterPolicyFluent.RolesNested<A> editRole(int index);
    public ClusterPolicyFluent.RolesNested<A> editFirstRole();
    public ClusterPolicyFluent.RolesNested<A> editLastRole();
    public ClusterPolicyFluent.RolesNested<A> editMatchingRole(io.fabric8.kubernetes.api.builder.Predicate<NamedClusterRoleBuilder> predicate);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterPolicyFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RolesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedClusterRoleFluent<ClusterPolicyFluent.RolesNested<N>>{

        
    public N and();    public N endRole();
}


}
