package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PolicyListFluent<A extends PolicyListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,Policy item);
    public A setToItems(int index,Policy item);
    public A addToItems(Policy... items);
    public A addAllToItems(Collection<Policy> items);
    public A removeFromItems(Policy... items);
    public A removeAllFromItems(Collection<Policy> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<Policy> getItems();
    public List<Policy> buildItems();
    public Policy buildItem(int index);
    public Policy buildFirstItem();
    public Policy buildLastItem();
    public Policy buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PolicyBuilder> predicate);
    public A withItems(List<Policy> items);
    public A withItems(Policy... items);
    public Boolean hasItems();
    public PolicyListFluent.ItemsNested<A> addNewItem();
    public PolicyListFluent.ItemsNested<A> addNewItemLike(Policy item);
    public PolicyListFluent.ItemsNested<A> setNewItemLike(int index,Policy item);
    public PolicyListFluent.ItemsNested<A> editItem(int index);
    public PolicyListFluent.ItemsNested<A> editFirstItem();
    public PolicyListFluent.ItemsNested<A> editLastItem();
    public PolicyListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PolicyBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public PolicyListFluent.MetadataNested<A> withNewMetadata();
    public PolicyListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PolicyListFluent.MetadataNested<A> editMetadata();
    public PolicyListFluent.MetadataNested<A> editOrNewMetadata();
    public PolicyListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PolicyFluent<PolicyListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<PolicyListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
