package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class PodSecurityPolicySpecFluentImpl<A extends PodSecurityPolicySpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSecurityPolicySpecFluent<A>{

    private List<String> allowedCapabilities = new ArrayList<String>();
    private List<String> defaultAddCapabilities = new ArrayList<String>();
    private FSGroupStrategyOptionsBuilder fsGroup;
    private Boolean hostIPC;
    private Boolean hostNetwork;
    private Boolean hostPID;
    private List<HostPortRangeBuilder> hostPorts =  new ArrayList<HostPortRangeBuilder>();
    private Boolean privileged;
    private Boolean readOnlyRootFilesystem;
    private List<String> requiredDropCapabilities = new ArrayList<String>();
    private KubernetesRunAsUserStrategyOptionsBuilder runAsUser;
    private SELinuxStrategyOptionsBuilder seLinux;
    private SupplementalGroupsStrategyOptionsBuilder supplementalGroups;
    private List<String> volumes = new ArrayList<String>();

    public PodSecurityPolicySpecFluentImpl(){
    }
    public PodSecurityPolicySpecFluentImpl(PodSecurityPolicySpec instance){
            this.withAllowedCapabilities(instance.getAllowedCapabilities()); 
            this.withDefaultAddCapabilities(instance.getDefaultAddCapabilities()); 
            this.withFsGroup(instance.getFsGroup()); 
            this.withHostIPC(instance.getHostIPC()); 
            this.withHostNetwork(instance.getHostNetwork()); 
            this.withHostPID(instance.getHostPID()); 
            this.withHostPorts(instance.getHostPorts()); 
            this.withPrivileged(instance.getPrivileged()); 
            this.withReadOnlyRootFilesystem(instance.getReadOnlyRootFilesystem()); 
            this.withRequiredDropCapabilities(instance.getRequiredDropCapabilities()); 
            this.withRunAsUser(instance.getRunAsUser()); 
            this.withSeLinux(instance.getSeLinux()); 
            this.withSupplementalGroups(instance.getSupplementalGroups()); 
            this.withVolumes(instance.getVolumes()); 
    }

    public A addToAllowedCapabilities(int index,String item){
            this.allowedCapabilities.add(index, item); return (A)this;
    }

    public A setToAllowedCapabilities(int index,String item){
            this.allowedCapabilities.set(index, item); return (A)this;
    }

    public A addToAllowedCapabilities(String... items){
            for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
    }

    public A addAllToAllowedCapabilities(Collection<String> items){
            for (String item : items) {this.allowedCapabilities.add(item);} return (A)this;
    }

    public A removeFromAllowedCapabilities(String... items){
            for (String item : items) {this.allowedCapabilities.remove(item);} return (A)this;
    }

    public A removeAllFromAllowedCapabilities(Collection<String> items){
            for (String item : items) {this.allowedCapabilities.remove(item);} return (A)this;
    }

    public List<String> getAllowedCapabilities(){
            return this.allowedCapabilities;
    }

    public String getAllowedCapability(int index){
            return this.allowedCapabilities.get(index);
    }

    public String getFirstAllowedCapability(){
            return this.allowedCapabilities.get(0);
    }

    public String getLastAllowedCapability(){
            return this.allowedCapabilities.get(allowedCapabilities.size() - 1);
    }

    public String getMatchingAllowedCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: allowedCapabilities) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withAllowedCapabilities(List<String> allowedCapabilities){
            this.allowedCapabilities.clear();
            if (allowedCapabilities != null) {for (String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} return (A) this;
    }

    public A withAllowedCapabilities(String... allowedCapabilities){
            this.allowedCapabilities.clear(); if (allowedCapabilities != null) {for (String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (A) this;
    }

    public Boolean hasAllowedCapabilities(){
            return allowedCapabilities!= null && !allowedCapabilities.isEmpty();
    }

    public A addToDefaultAddCapabilities(int index,String item){
            this.defaultAddCapabilities.add(index, item); return (A)this;
    }

    public A setToDefaultAddCapabilities(int index,String item){
            this.defaultAddCapabilities.set(index, item); return (A)this;
    }

    public A addToDefaultAddCapabilities(String... items){
            for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
    }

    public A addAllToDefaultAddCapabilities(Collection<String> items){
            for (String item : items) {this.defaultAddCapabilities.add(item);} return (A)this;
    }

    public A removeFromDefaultAddCapabilities(String... items){
            for (String item : items) {this.defaultAddCapabilities.remove(item);} return (A)this;
    }

    public A removeAllFromDefaultAddCapabilities(Collection<String> items){
            for (String item : items) {this.defaultAddCapabilities.remove(item);} return (A)this;
    }

    public List<String> getDefaultAddCapabilities(){
            return this.defaultAddCapabilities;
    }

    public String getDefaultAddCapability(int index){
            return this.defaultAddCapabilities.get(index);
    }

    public String getFirstDefaultAddCapability(){
            return this.defaultAddCapabilities.get(0);
    }

    public String getLastDefaultAddCapability(){
            return this.defaultAddCapabilities.get(defaultAddCapabilities.size() - 1);
    }

    public String getMatchingDefaultAddCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: defaultAddCapabilities) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities){
            this.defaultAddCapabilities.clear();
            if (defaultAddCapabilities != null) {for (String item : defaultAddCapabilities){this.addToDefaultAddCapabilities(item);}} return (A) this;
    }

    public A withDefaultAddCapabilities(String... defaultAddCapabilities){
            this.defaultAddCapabilities.clear(); if (defaultAddCapabilities != null) {for (String item :defaultAddCapabilities){ this.addToDefaultAddCapabilities(item);}} return (A) this;
    }

    public Boolean hasDefaultAddCapabilities(){
            return defaultAddCapabilities!= null && !defaultAddCapabilities.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildFsGroup instead.
 */
@Deprecated public FSGroupStrategyOptions getFsGroup(){
            return this.fsGroup!=null?this.fsGroup.build():null;
    }

    public FSGroupStrategyOptions buildFsGroup(){
            return this.fsGroup!=null?this.fsGroup.build():null;
    }

    public A withFsGroup(FSGroupStrategyOptions fsGroup){
            _visitables.remove(this.fsGroup);
            if (fsGroup!=null){ this.fsGroup= new FSGroupStrategyOptionsBuilder(fsGroup); _visitables.add(this.fsGroup);} return (A) this;
    }

    public Boolean hasFsGroup(){
            return this.fsGroup!=null;
    }

    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup(){
            return new FsGroupNestedImpl();
    }

    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item){
            return new FsGroupNestedImpl(item);
    }

    public PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup(){
            return withNewFsGroupLike(getFsGroup());
    }

    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup(){
            return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): new FSGroupStrategyOptionsBuilder().build());
    }

    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item){
            return withNewFsGroupLike(getFsGroup() != null ? getFsGroup(): item);
    }

    public Boolean isHostIPC(){
            return this.hostIPC;
    }

    public A withHostIPC(Boolean hostIPC){
            this.hostIPC=hostIPC; return (A) this;
    }

    public Boolean hasHostIPC(){
            return this.hostIPC!=null;
    }

    public Boolean isHostNetwork(){
            return this.hostNetwork;
    }

    public A withHostNetwork(Boolean hostNetwork){
            this.hostNetwork=hostNetwork; return (A) this;
    }

    public Boolean hasHostNetwork(){
            return this.hostNetwork!=null;
    }

    public Boolean isHostPID(){
            return this.hostPID;
    }

    public A withHostPID(Boolean hostPID){
            this.hostPID=hostPID; return (A) this;
    }

    public Boolean hasHostPID(){
            return this.hostPID!=null;
    }

    public A addToHostPorts(int index,HostPortRange item){
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.hostPorts.add(index >= 0 ? index : hostPorts.size(), builder); return (A)this;
    }

    public A setToHostPorts(int index,HostPortRange item){
            HostPortRangeBuilder builder = new HostPortRangeBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= hostPorts.size()) { hostPorts.add(builder); } else { hostPorts.set(index, builder);}
             return (A)this;
    }

    public A addToHostPorts(HostPortRange... items){
            for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.add(builder);this.hostPorts.add(builder);} return (A)this;
    }

    public A addAllToHostPorts(Collection<HostPortRange> items){
            for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.add(builder);this.hostPorts.add(builder);} return (A)this;
    }

    public A removeFromHostPorts(HostPortRange... items){
            for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.remove(builder);this.hostPorts.remove(builder);} return (A)this;
    }

    public A removeAllFromHostPorts(Collection<HostPortRange> items){
            for (HostPortRange item : items) {HostPortRangeBuilder builder = new HostPortRangeBuilder(item);_visitables.remove(builder);this.hostPorts.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildHostPorts instead.
 */
@Deprecated public List<HostPortRange> getHostPorts(){
            return build(hostPorts);
    }

    public List<HostPortRange> buildHostPorts(){
            return build(hostPorts);
    }

    public HostPortRange buildHostPort(int index){
            return this.hostPorts.get(index).build();
    }

    public HostPortRange buildFirstHostPort(){
            return this.hostPorts.get(0).build();
    }

    public HostPortRange buildLastHostPort(){
            return this.hostPorts.get(hostPorts.size() - 1).build();
    }

    public HostPortRange buildMatchingHostPort(io.fabric8.kubernetes.api.builder.Predicate<HostPortRangeBuilder> predicate){
            for (HostPortRangeBuilder item: hostPorts) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withHostPorts(List<HostPortRange> hostPorts){
            _visitables.removeAll(this.hostPorts);
            this.hostPorts.clear();
            if (hostPorts != null) {for (HostPortRange item : hostPorts){this.addToHostPorts(item);}} return (A) this;
    }

    public A withHostPorts(HostPortRange... hostPorts){
            this.hostPorts.clear(); if (hostPorts != null) {for (HostPortRange item :hostPorts){ this.addToHostPorts(item);}} return (A) this;
    }

    public Boolean hasHostPorts(){
            return hostPorts!= null && !hostPorts.isEmpty();
    }

    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort(){
            return new HostPortsNestedImpl();
    }

    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(HostPortRange item){
            return new HostPortsNestedImpl(-1, item);
    }

    public PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index,HostPortRange item){
            return new HostPortsNestedImpl(index, item);
    }

    public PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index){
            if (hostPorts.size() <= index) throw new RuntimeException("Can't edit hostPorts. Index exceeds size.");
            return setNewHostPortLike(index, buildHostPort(index));
    }

    public PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort(){
            if (hostPorts.size() == 0) throw new RuntimeException("Can't edit first hostPorts. The list is empty.");
            return setNewHostPortLike(0, buildHostPort(0));
    }

    public PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort(){
            int index = hostPorts.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last hostPorts. The list is empty.");
            return setNewHostPortLike(index, buildHostPort(index));
    }

    public PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(io.fabric8.kubernetes.api.builder.Predicate<HostPortRangeBuilder> predicate){
            int index = -1;
            for (int i=0;i<hostPorts.size();i++) { 
            if (predicate.apply(hostPorts.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching hostPorts. No match found.");
            return setNewHostPortLike(index, buildHostPort(index));
    }

    public A addNewHostPort(Integer max,Integer min){
            return (A)addToHostPorts(new HostPortRange(max, min));
    }

    public Boolean isPrivileged(){
            return this.privileged;
    }

    public A withPrivileged(Boolean privileged){
            this.privileged=privileged; return (A) this;
    }

    public Boolean hasPrivileged(){
            return this.privileged!=null;
    }

    public Boolean isReadOnlyRootFilesystem(){
            return this.readOnlyRootFilesystem;
    }

    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem){
            this.readOnlyRootFilesystem=readOnlyRootFilesystem; return (A) this;
    }

    public Boolean hasReadOnlyRootFilesystem(){
            return this.readOnlyRootFilesystem!=null;
    }

    public A addToRequiredDropCapabilities(int index,String item){
            this.requiredDropCapabilities.add(index, item); return (A)this;
    }

    public A setToRequiredDropCapabilities(int index,String item){
            this.requiredDropCapabilities.set(index, item); return (A)this;
    }

    public A addToRequiredDropCapabilities(String... items){
            for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
    }

    public A addAllToRequiredDropCapabilities(Collection<String> items){
            for (String item : items) {this.requiredDropCapabilities.add(item);} return (A)this;
    }

    public A removeFromRequiredDropCapabilities(String... items){
            for (String item : items) {this.requiredDropCapabilities.remove(item);} return (A)this;
    }

    public A removeAllFromRequiredDropCapabilities(Collection<String> items){
            for (String item : items) {this.requiredDropCapabilities.remove(item);} return (A)this;
    }

    public List<String> getRequiredDropCapabilities(){
            return this.requiredDropCapabilities;
    }

    public String getRequiredDropCapability(int index){
            return this.requiredDropCapabilities.get(index);
    }

    public String getFirstRequiredDropCapability(){
            return this.requiredDropCapabilities.get(0);
    }

    public String getLastRequiredDropCapability(){
            return this.requiredDropCapabilities.get(requiredDropCapabilities.size() - 1);
    }

    public String getMatchingRequiredDropCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: requiredDropCapabilities) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities){
            this.requiredDropCapabilities.clear();
            if (requiredDropCapabilities != null) {for (String item : requiredDropCapabilities){this.addToRequiredDropCapabilities(item);}} return (A) this;
    }

    public A withRequiredDropCapabilities(String... requiredDropCapabilities){
            this.requiredDropCapabilities.clear(); if (requiredDropCapabilities != null) {for (String item :requiredDropCapabilities){ this.addToRequiredDropCapabilities(item);}} return (A) this;
    }

    public Boolean hasRequiredDropCapabilities(){
            return requiredDropCapabilities!= null && !requiredDropCapabilities.isEmpty();
    }

    
/**
 * This method has been deprecated, please use method buildRunAsUser instead.
 */
@Deprecated public KubernetesRunAsUserStrategyOptions getRunAsUser(){
            return this.runAsUser!=null?this.runAsUser.build():null;
    }

    public KubernetesRunAsUserStrategyOptions buildRunAsUser(){
            return this.runAsUser!=null?this.runAsUser.build():null;
    }

    public A withRunAsUser(KubernetesRunAsUserStrategyOptions runAsUser){
            _visitables.remove(this.runAsUser);
            if (runAsUser!=null){ this.runAsUser= new KubernetesRunAsUserStrategyOptionsBuilder(runAsUser); _visitables.add(this.runAsUser);} return (A) this;
    }

    public Boolean hasRunAsUser(){
            return this.runAsUser!=null;
    }

    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser(){
            return new RunAsUserNestedImpl();
    }

    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(KubernetesRunAsUserStrategyOptions item){
            return new RunAsUserNestedImpl(item);
    }

    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser(){
            return withNewRunAsUserLike(getRunAsUser());
    }

    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser(){
            return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): new KubernetesRunAsUserStrategyOptionsBuilder().build());
    }

    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(KubernetesRunAsUserStrategyOptions item){
            return withNewRunAsUserLike(getRunAsUser() != null ? getRunAsUser(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSeLinux instead.
 */
@Deprecated public SELinuxStrategyOptions getSeLinux(){
            return this.seLinux!=null?this.seLinux.build():null;
    }

    public SELinuxStrategyOptions buildSeLinux(){
            return this.seLinux!=null?this.seLinux.build():null;
    }

    public A withSeLinux(SELinuxStrategyOptions seLinux){
            _visitables.remove(this.seLinux);
            if (seLinux!=null){ this.seLinux= new SELinuxStrategyOptionsBuilder(seLinux); _visitables.add(this.seLinux);} return (A) this;
    }

    public Boolean hasSeLinux(){
            return this.seLinux!=null;
    }

    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux(){
            return new SeLinuxNestedImpl();
    }

    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(SELinuxStrategyOptions item){
            return new SeLinuxNestedImpl(item);
    }

    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux(){
            return withNewSeLinuxLike(getSeLinux());
    }

    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux(){
            return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): new SELinuxStrategyOptionsBuilder().build());
    }

    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(SELinuxStrategyOptions item){
            return withNewSeLinuxLike(getSeLinux() != null ? getSeLinux(): item);
    }

    
/**
 * This method has been deprecated, please use method buildSupplementalGroups instead.
 */
@Deprecated public SupplementalGroupsStrategyOptions getSupplementalGroups(){
            return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }

    public SupplementalGroupsStrategyOptions buildSupplementalGroups(){
            return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }

    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups){
            _visitables.remove(this.supplementalGroups);
            if (supplementalGroups!=null){ this.supplementalGroups= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.add(this.supplementalGroups);} return (A) this;
    }

    public Boolean hasSupplementalGroups(){
            return this.supplementalGroups!=null;
    }

    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups(){
            return new SupplementalGroupsNestedImpl();
    }

    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item){
            return new SupplementalGroupsNestedImpl(item);
    }

    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups(){
            return withNewSupplementalGroupsLike(getSupplementalGroups());
    }

    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups(){
            return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): new SupplementalGroupsStrategyOptionsBuilder().build());
    }

    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item){
            return withNewSupplementalGroupsLike(getSupplementalGroups() != null ? getSupplementalGroups(): item);
    }

    public A addToVolumes(int index,String item){
            this.volumes.add(index, item); return (A)this;
    }

    public A setToVolumes(int index,String item){
            this.volumes.set(index, item); return (A)this;
    }

    public A addToVolumes(String... items){
            for (String item : items) {this.volumes.add(item);} return (A)this;
    }

    public A addAllToVolumes(Collection<String> items){
            for (String item : items) {this.volumes.add(item);} return (A)this;
    }

    public A removeFromVolumes(String... items){
            for (String item : items) {this.volumes.remove(item);} return (A)this;
    }

    public A removeAllFromVolumes(Collection<String> items){
            for (String item : items) {this.volumes.remove(item);} return (A)this;
    }

    public List<String> getVolumes(){
            return this.volumes;
    }

    public String getVolume(int index){
            return this.volumes.get(index);
    }

    public String getFirstVolume(){
            return this.volumes.get(0);
    }

    public String getLastVolume(){
            return this.volumes.get(volumes.size() - 1);
    }

    public String getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: volumes) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withVolumes(List<String> volumes){
            this.volumes.clear();
            if (volumes != null) {for (String item : volumes){this.addToVolumes(item);}} return (A) this;
    }

    public A withVolumes(String... volumes){
            this.volumes.clear(); if (volumes != null) {for (String item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes(){
            return volumes!= null && !volumes.isEmpty();
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodSecurityPolicySpecFluentImpl that = (PodSecurityPolicySpecFluentImpl) o;
            if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
            if (defaultAddCapabilities != null ? !defaultAddCapabilities.equals(that.defaultAddCapabilities) :that.defaultAddCapabilities != null) return false;
            if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
            if (hostIPC != null ? !hostIPC.equals(that.hostIPC) :that.hostIPC != null) return false;
            if (hostNetwork != null ? !hostNetwork.equals(that.hostNetwork) :that.hostNetwork != null) return false;
            if (hostPID != null ? !hostPID.equals(that.hostPID) :that.hostPID != null) return false;
            if (hostPorts != null ? !hostPorts.equals(that.hostPorts) :that.hostPorts != null) return false;
            if (privileged != null ? !privileged.equals(that.privileged) :that.privileged != null) return false;
            if (readOnlyRootFilesystem != null ? !readOnlyRootFilesystem.equals(that.readOnlyRootFilesystem) :that.readOnlyRootFilesystem != null) return false;
            if (requiredDropCapabilities != null ? !requiredDropCapabilities.equals(that.requiredDropCapabilities) :that.requiredDropCapabilities != null) return false;
            if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
            if (seLinux != null ? !seLinux.equals(that.seLinux) :that.seLinux != null) return false;
            if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
            if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
            return true;
    }


    public class FsGroupNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.FsGroupNested<N>> implements PodSecurityPolicySpecFluent.FsGroupNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final FSGroupStrategyOptionsBuilder builder;
    
            FsGroupNestedImpl(FSGroupStrategyOptions item){
                    this.builder = new FSGroupStrategyOptionsBuilder(this, item);
            }
            FsGroupNestedImpl(){
                    this.builder = new FSGroupStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) PodSecurityPolicySpecFluentImpl.this.withFsGroup(builder.build());
    }
    public N endFsGroup(){
            return and();
    }

}
    public class HostPortsNestedImpl<N> extends HostPortRangeFluentImpl<PodSecurityPolicySpecFluent.HostPortsNested<N>> implements PodSecurityPolicySpecFluent.HostPortsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final HostPortRangeBuilder builder;
        private final int index;
    
            HostPortsNestedImpl(int index,HostPortRange item){
                    this.index = index;
                    this.builder = new HostPortRangeBuilder(this, item);
            }
            HostPortsNestedImpl(){
                    this.index = -1;
                    this.builder = new HostPortRangeBuilder(this);
            }
    
    public N and(){
            return (N) PodSecurityPolicySpecFluentImpl.this.setToHostPorts(index, builder.build());
    }
    public N endHostPort(){
            return and();
    }

}
    public class RunAsUserNestedImpl<N> extends KubernetesRunAsUserStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.RunAsUserNested<N>> implements PodSecurityPolicySpecFluent.RunAsUserNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final KubernetesRunAsUserStrategyOptionsBuilder builder;
    
            RunAsUserNestedImpl(KubernetesRunAsUserStrategyOptions item){
                    this.builder = new KubernetesRunAsUserStrategyOptionsBuilder(this, item);
            }
            RunAsUserNestedImpl(){
                    this.builder = new KubernetesRunAsUserStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) PodSecurityPolicySpecFluentImpl.this.withRunAsUser(builder.build());
    }
    public N endRunAsUser(){
            return and();
    }

}
    public class SeLinuxNestedImpl<N> extends SELinuxStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SeLinuxNested<N>> implements PodSecurityPolicySpecFluent.SeLinuxNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SELinuxStrategyOptionsBuilder builder;
    
            SeLinuxNestedImpl(SELinuxStrategyOptions item){
                    this.builder = new SELinuxStrategyOptionsBuilder(this, item);
            }
            SeLinuxNestedImpl(){
                    this.builder = new SELinuxStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) PodSecurityPolicySpecFluentImpl.this.withSeLinux(builder.build());
    }
    public N endSeLinux(){
            return and();
    }

}
    public class SupplementalGroupsNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>> implements PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SupplementalGroupsStrategyOptionsBuilder builder;
    
            SupplementalGroupsNestedImpl(SupplementalGroupsStrategyOptions item){
                    this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
            }
            SupplementalGroupsNestedImpl(){
                    this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
            }
    
    public N and(){
            return (N) PodSecurityPolicySpecFluentImpl.this.withSupplementalGroups(builder.build());
    }
    public N endSupplementalGroups(){
            return and();
    }

}


}
