package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface PodSecurityPolicySpecFluent<A extends PodSecurityPolicySpecFluent<A>> extends Fluent<A>{


    public A addToAllowedCapabilities(int index,String item);
    public A setToAllowedCapabilities(int index,String item);
    public A addToAllowedCapabilities(String... items);
    public A addAllToAllowedCapabilities(Collection<String> items);
    public A removeFromAllowedCapabilities(String... items);
    public A removeAllFromAllowedCapabilities(Collection<String> items);
    public List<String> getAllowedCapabilities();
    public String getAllowedCapability(int index);
    public String getFirstAllowedCapability();
    public String getLastAllowedCapability();
    public String getMatchingAllowedCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withAllowedCapabilities(List<String> allowedCapabilities);
    public A withAllowedCapabilities(String... allowedCapabilities);
    public Boolean hasAllowedCapabilities();
    public A addToDefaultAddCapabilities(int index,String item);
    public A setToDefaultAddCapabilities(int index,String item);
    public A addToDefaultAddCapabilities(String... items);
    public A addAllToDefaultAddCapabilities(Collection<String> items);
    public A removeFromDefaultAddCapabilities(String... items);
    public A removeAllFromDefaultAddCapabilities(Collection<String> items);
    public List<String> getDefaultAddCapabilities();
    public String getDefaultAddCapability(int index);
    public String getFirstDefaultAddCapability();
    public String getLastDefaultAddCapability();
    public String getMatchingDefaultAddCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
    public A withDefaultAddCapabilities(String... defaultAddCapabilities);
    public Boolean hasDefaultAddCapabilities();
    
/**
 * This method has been deprecated, please use method buildFsGroup instead.
 */
@Deprecated public FSGroupStrategyOptions getFsGroup();
    public FSGroupStrategyOptions buildFsGroup();
    public A withFsGroup(FSGroupStrategyOptions fsGroup);
    public Boolean hasFsGroup();
    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroup();
    public PodSecurityPolicySpecFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item);
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editFsGroup();
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroup();
    public PodSecurityPolicySpecFluent.FsGroupNested<A> editOrNewFsGroupLike(FSGroupStrategyOptions item);
    public Boolean isHostIPC();
    public A withHostIPC(Boolean hostIPC);
    public Boolean hasHostIPC();
    public Boolean isHostNetwork();
    public A withHostNetwork(Boolean hostNetwork);
    public Boolean hasHostNetwork();
    public Boolean isHostPID();
    public A withHostPID(Boolean hostPID);
    public Boolean hasHostPID();
    public A addToHostPorts(int index,HostPortRange item);
    public A setToHostPorts(int index,HostPortRange item);
    public A addToHostPorts(HostPortRange... items);
    public A addAllToHostPorts(Collection<HostPortRange> items);
    public A removeFromHostPorts(HostPortRange... items);
    public A removeAllFromHostPorts(Collection<HostPortRange> items);
    
/**
 * This method has been deprecated, please use method buildHostPorts instead.
 */
@Deprecated public List<HostPortRange> getHostPorts();
    public List<HostPortRange> buildHostPorts();
    public HostPortRange buildHostPort(int index);
    public HostPortRange buildFirstHostPort();
    public HostPortRange buildLastHostPort();
    public HostPortRange buildMatchingHostPort(io.fabric8.kubernetes.api.builder.Predicate<HostPortRangeBuilder> predicate);
    public A withHostPorts(List<HostPortRange> hostPorts);
    public A withHostPorts(HostPortRange... hostPorts);
    public Boolean hasHostPorts();
    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPort();
    public PodSecurityPolicySpecFluent.HostPortsNested<A> addNewHostPortLike(HostPortRange item);
    public PodSecurityPolicySpecFluent.HostPortsNested<A> setNewHostPortLike(int index,HostPortRange item);
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editHostPort(int index);
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editFirstHostPort();
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editLastHostPort();
    public PodSecurityPolicySpecFluent.HostPortsNested<A> editMatchingHostPort(io.fabric8.kubernetes.api.builder.Predicate<HostPortRangeBuilder> predicate);
    public A addNewHostPort(Integer max,Integer min);
    public Boolean isPrivileged();
    public A withPrivileged(Boolean privileged);
    public Boolean hasPrivileged();
    public Boolean isReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public Boolean hasReadOnlyRootFilesystem();
    public A addToRequiredDropCapabilities(int index,String item);
    public A setToRequiredDropCapabilities(int index,String item);
    public A addToRequiredDropCapabilities(String... items);
    public A addAllToRequiredDropCapabilities(Collection<String> items);
    public A removeFromRequiredDropCapabilities(String... items);
    public A removeAllFromRequiredDropCapabilities(Collection<String> items);
    public List<String> getRequiredDropCapabilities();
    public String getRequiredDropCapability(int index);
    public String getFirstRequiredDropCapability();
    public String getLastRequiredDropCapability();
    public String getMatchingRequiredDropCapability(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
    public A withRequiredDropCapabilities(String... requiredDropCapabilities);
    public Boolean hasRequiredDropCapabilities();
    
/**
 * This method has been deprecated, please use method buildRunAsUser instead.
 */
@Deprecated public KubernetesRunAsUserStrategyOptions getRunAsUser();
    public KubernetesRunAsUserStrategyOptions buildRunAsUser();
    public A withRunAsUser(KubernetesRunAsUserStrategyOptions runAsUser);
    public Boolean hasRunAsUser();
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUser();
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> withNewRunAsUserLike(KubernetesRunAsUserStrategyOptions item);
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editRunAsUser();
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUser();
    public PodSecurityPolicySpecFluent.RunAsUserNested<A> editOrNewRunAsUserLike(KubernetesRunAsUserStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildSeLinux instead.
 */
@Deprecated public SELinuxStrategyOptions getSeLinux();
    public SELinuxStrategyOptions buildSeLinux();
    public A withSeLinux(SELinuxStrategyOptions seLinux);
    public Boolean hasSeLinux();
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinux();
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> withNewSeLinuxLike(SELinuxStrategyOptions item);
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editSeLinux();
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinux();
    public PodSecurityPolicySpecFluent.SeLinuxNested<A> editOrNewSeLinuxLike(SELinuxStrategyOptions item);
    
/**
 * This method has been deprecated, please use method buildSupplementalGroups instead.
 */
@Deprecated public SupplementalGroupsStrategyOptions getSupplementalGroups();
    public SupplementalGroupsStrategyOptions buildSupplementalGroups();
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups);
    public Boolean hasSupplementalGroups();
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editSupplementalGroups();
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroups();
    public PodSecurityPolicySpecFluent.SupplementalGroupsNested<A> editOrNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
    public A addToVolumes(int index,String item);
    public A setToVolumes(int index,String item);
    public A addToVolumes(String... items);
    public A addAllToVolumes(Collection<String> items);
    public A removeFromVolumes(String... items);
    public A removeAllFromVolumes(Collection<String> items);
    public List<String> getVolumes();
    public String getVolume(int index);
    public String getFirstVolume();
    public String getLastVolume();
    public String getMatchingVolume(io.fabric8.kubernetes.api.builder.Predicate<String> predicate);
    public A withVolumes(List<String> volumes);
    public A withVolumes(String... volumes);
    public Boolean hasVolumes();

    public interface FsGroupNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FSGroupStrategyOptionsFluent<PodSecurityPolicySpecFluent.FsGroupNested<N>>{

        
    public N and();    public N endFsGroup();
}
    public interface HostPortsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HostPortRangeFluent<PodSecurityPolicySpecFluent.HostPortsNested<N>>{

        
    public N and();    public N endHostPort();
}
    public interface RunAsUserNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesRunAsUserStrategyOptionsFluent<PodSecurityPolicySpecFluent.RunAsUserNested<N>>{

        
    public N and();    public N endRunAsUser();
}
    public interface SeLinuxNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SELinuxStrategyOptionsFluent<PodSecurityPolicySpecFluent.SeLinuxNested<N>>{

        
    public N and();    public N endSeLinux();
}
    public interface SupplementalGroupsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SupplementalGroupsStrategyOptionsFluent<PodSecurityPolicySpecFluent.SupplementalGroupsNested<N>>{

        
    public N and();    public N endSupplementalGroups();
}


}
