package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;

public class ThirdPartyResourceFluentImpl<A extends ThirdPartyResourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ThirdPartyResourceFluent<A>{

    private String apiVersion;
    private String description;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<APIVersionBuilder> versions =  new ArrayList<APIVersionBuilder>();

    public ThirdPartyResourceFluentImpl(){
    }
    public ThirdPartyResourceFluentImpl(ThirdPartyResource instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withDescription(instance.getDescription()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withVersions(instance.getVersions()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion!=null;
    }

    public String getDescription(){
            return this.description;
    }

    public A withDescription(String description){
            this.description=description; return (A) this;
    }

    public Boolean hasDescription(){
            return this.description!=null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind!=null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata!=null;
    }

    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ThirdPartyResourceFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ThirdPartyResourceFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public ThirdPartyResourceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToVersions(int index,APIVersion item){
            APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.add(index >= 0 ? index : _visitables.size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
    }

    public A setToVersions(int index,APIVersion item){
            APIVersionBuilder builder = new APIVersionBuilder(item);
            if (index < 0 || index >= _visitables.size()) { _visitables.add(builder); } else { _visitables.set(index, builder);}
            if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
             return (A)this;
    }

    public A addToVersions(APIVersion... items){
            for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.add(builder);this.versions.add(builder);} return (A)this;
    }

    public A addAllToVersions(Collection<APIVersion> items){
            for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.add(builder);this.versions.add(builder);} return (A)this;
    }

    public A removeFromVersions(APIVersion... items){
            for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.remove(builder);this.versions.remove(builder);} return (A)this;
    }

    public A removeAllFromVersions(Collection<APIVersion> items){
            for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.remove(builder);this.versions.remove(builder);} return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVersions instead.
 */
@Deprecated public List<APIVersion> getVersions(){
            return build(versions);
    }

    public List<APIVersion> buildVersions(){
            return build(versions);
    }

    public APIVersion buildVersion(int index){
            return this.versions.get(index).build();
    }

    public APIVersion buildFirstVersion(){
            return this.versions.get(0).build();
    }

    public APIVersion buildLastVersion(){
            return this.versions.get(versions.size() - 1).build();
    }

    public APIVersion buildMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<APIVersionBuilder> predicate){
            for (APIVersionBuilder item: versions) { if(predicate.apply(item)){return item.build();} } return null;
    }

    public A withVersions(List<APIVersion> versions){
            _visitables.removeAll(this.versions);
            this.versions.clear();
            if (versions != null) {for (APIVersion item : versions){this.addToVersions(item);}} return (A) this;
    }

    public A withVersions(APIVersion... versions){
            this.versions.clear(); if (versions != null) {for (APIVersion item :versions){ this.addToVersions(item);}} return (A) this;
    }

    public Boolean hasVersions(){
            return versions!= null && !versions.isEmpty();
    }

    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersion(){
            return new VersionsNestedImpl();
    }

    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersionLike(APIVersion item){
            return new VersionsNestedImpl(-1, item);
    }

    public ThirdPartyResourceFluent.VersionsNested<A> setNewVersionLike(int index,APIVersion item){
            return new VersionsNestedImpl(index, item);
    }

    public ThirdPartyResourceFluent.VersionsNested<A> editVersion(int index){
            if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
            return setNewVersionLike(index, buildVersion(index));
    }

    public ThirdPartyResourceFluent.VersionsNested<A> editFirstVersion(){
            if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
            return setNewVersionLike(0, buildVersion(0));
    }

    public ThirdPartyResourceFluent.VersionsNested<A> editLastVersion(){
            int index = versions.size() - 1;
            if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
            return setNewVersionLike(index, buildVersion(index));
    }

    public ThirdPartyResourceFluent.VersionsNested<A> editMatchingVersion(io.fabric8.kubernetes.api.builder.Predicate<APIVersionBuilder> predicate){
            int index = -1;
            for (int i=0;i<versions.size();i++) { 
            if (predicate.apply(versions.get(i))) {index = i; break;}
            } 
            if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
            return setNewVersionLike(index, buildVersion(index));
    }

    public A addNewVersion(String name){
            return (A)addToVersions(new APIVersion(name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThirdPartyResourceFluentImpl that = (ThirdPartyResourceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ThirdPartyResourceFluent.MetadataNested<N>> implements ThirdPartyResourceFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class VersionsNestedImpl<N> extends APIVersionFluentImpl<ThirdPartyResourceFluent.VersionsNested<N>> implements ThirdPartyResourceFluent.VersionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final APIVersionBuilder builder;
        private final int index;
    
            VersionsNestedImpl(int index,APIVersion item){
                    this.index = index;
                    this.builder = new APIVersionBuilder(this, item);
            }
            VersionsNestedImpl(){
                    this.index = -1;
                    this.builder = new APIVersionBuilder(this);
            }
    
    public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.setToVersions(index, builder.build());
    }
    public N endVersion(){
            return and();
    }

}


}
