package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class StorageClassBuilder extends StorageClassFluentImpl<StorageClassBuilder> implements VisitableBuilder<StorageClass,StorageClassBuilder>{

    StorageClassFluent<?> fluent;
    Boolean validationEnabled;

    public StorageClassBuilder(){
            this(true);
    }
    public StorageClassBuilder(Boolean validationEnabled){
            this(new StorageClass(), validationEnabled);
    }
    public StorageClassBuilder(StorageClassFluent<?> fluent){
            this(fluent, true);
    }
    public StorageClassBuilder(StorageClassFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new StorageClass(), validationEnabled);
    }
    public StorageClassBuilder(StorageClassFluent<?> fluent,StorageClass instance){
            this(fluent, instance, true);
    }
    public StorageClassBuilder(StorageClassFluent<?> fluent,StorageClass instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withParameters(instance.getParameters()); 
            fluent.withProvisioner(instance.getProvisioner()); 
            this.validationEnabled = validationEnabled; 
    }
    public StorageClassBuilder(StorageClass instance){
            this(instance,true);
    }
    public StorageClassBuilder(StorageClass instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withParameters(instance.getParameters()); 
            this.withProvisioner(instance.getProvisioner()); 
            this.validationEnabled = validationEnabled; 
    }

    public StorageClass build(){
            StorageClass buildable = new StorageClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getParameters(),fluent.getProvisioner());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StorageClassBuilder that = (StorageClassBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
