package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class KubernetesRoleRefBuilder extends KubernetesRoleRefFluentImpl<KubernetesRoleRefBuilder> implements VisitableBuilder<KubernetesRoleRef,KubernetesRoleRefBuilder>{

    KubernetesRoleRefFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesRoleRefBuilder(){
            this(true);
    }
    public KubernetesRoleRefBuilder(Boolean validationEnabled){
            this(new KubernetesRoleRef(), validationEnabled);
    }
    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesRoleRef(), validationEnabled);
    }
    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent,KubernetesRoleRef instance){
            this(fluent, instance, true);
    }
    public KubernetesRoleRefBuilder(KubernetesRoleRefFluent<?> fluent,KubernetesRoleRef instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroup(instance.getApiGroup()); 
            fluent.withKind(instance.getKind()); 
            fluent.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleRefBuilder(KubernetesRoleRef instance){
            this(instance,true);
    }
    public KubernetesRoleRefBuilder(KubernetesRoleRef instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroup(instance.getApiGroup()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.validationEnabled = validationEnabled; 
    }

    public KubernetesRoleRef build(){
            KubernetesRoleRef buildable = new KubernetesRoleRef(fluent.getApiGroup(),fluent.getKind(),fluent.getName());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesRoleRefBuilder that = (KubernetesRoleRefBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
