package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public interface ClusterPolicyBindingFluent<A extends ClusterPolicyBindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public String getLastModified();
    public A withLastModified(String lastModified);
    public Boolean hasLastModified();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ClusterPolicyBindingFluent.MetadataNested<A> editMetadata();
    public ClusterPolicyBindingFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterPolicyBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    
/**
 * This method has been deprecated, please use method buildPolicyRef instead.
 */
@Deprecated public ObjectReference getPolicyRef();
    public ObjectReference buildPolicyRef();
    public A withPolicyRef(ObjectReference policyRef);
    public Boolean hasPolicyRef();
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRef();
    public ClusterPolicyBindingFluent.PolicyRefNested<A> withNewPolicyRefLike(ObjectReference item);
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editPolicyRef();
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRef();
    public ClusterPolicyBindingFluent.PolicyRefNested<A> editOrNewPolicyRefLike(ObjectReference item);
    public A addToRoleBindings(int index,NamedClusterRoleBinding item);
    public A setToRoleBindings(int index,NamedClusterRoleBinding item);
    public A addToRoleBindings(NamedClusterRoleBinding... items);
    public A addAllToRoleBindings(Collection<NamedClusterRoleBinding> items);
    public A removeFromRoleBindings(NamedClusterRoleBinding... items);
    public A removeAllFromRoleBindings(Collection<NamedClusterRoleBinding> items);
    
/**
 * This method has been deprecated, please use method buildRoleBindings instead.
 */
@Deprecated public List<NamedClusterRoleBinding> getRoleBindings();
    public List<NamedClusterRoleBinding> buildRoleBindings();
    public NamedClusterRoleBinding buildRoleBinding(int index);
    public NamedClusterRoleBinding buildFirstRoleBinding();
    public NamedClusterRoleBinding buildLastRoleBinding();
    public NamedClusterRoleBinding buildMatchingRoleBinding(io.fabric8.kubernetes.api.builder.Predicate<NamedClusterRoleBindingBuilder> predicate);
    public A withRoleBindings(List<NamedClusterRoleBinding> roleBindings);
    public A withRoleBindings(NamedClusterRoleBinding... roleBindings);
    public Boolean hasRoleBindings();
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBinding();
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> addNewRoleBindingLike(NamedClusterRoleBinding item);
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> setNewRoleBindingLike(int index,NamedClusterRoleBinding item);
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editRoleBinding(int index);
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editFirstRoleBinding();
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editLastRoleBinding();
    public ClusterPolicyBindingFluent.RoleBindingsNested<A> editMatchingRoleBinding(io.fabric8.kubernetes.api.builder.Predicate<NamedClusterRoleBindingBuilder> predicate);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ClusterPolicyBindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface PolicyRefNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<ClusterPolicyBindingFluent.PolicyRefNested<N>>{

        
    public N and();    public N endPolicyRef();
}
    public interface RoleBindingsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NamedClusterRoleBindingFluent<ClusterPolicyBindingFluent.RoleBindingsNested<N>>{

        
    public N and();    public N endRoleBinding();
}


}
