package io.fabric8.kubernetes.api.model.rbac;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface KubernetesClusterRoleBindingListFluent<A extends KubernetesClusterRoleBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,KubernetesClusterRoleBinding item);
    public A setToItems(int index,KubernetesClusterRoleBinding item);
    public A addToItems(KubernetesClusterRoleBinding... items);
    public A addAllToItems(Collection<KubernetesClusterRoleBinding> items);
    public A removeFromItems(KubernetesClusterRoleBinding... items);
    public A removeAllFromItems(Collection<KubernetesClusterRoleBinding> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<KubernetesClusterRoleBinding> getItems();
    public List<KubernetesClusterRoleBinding> buildItems();
    public KubernetesClusterRoleBinding buildItem(int index);
    public KubernetesClusterRoleBinding buildFirstItem();
    public KubernetesClusterRoleBinding buildLastItem();
    public KubernetesClusterRoleBinding buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesClusterRoleBindingBuilder> predicate);
    public A withItems(List<KubernetesClusterRoleBinding> items);
    public A withItems(KubernetesClusterRoleBinding... items);
    public Boolean hasItems();
    public KubernetesClusterRoleBindingListFluent.ItemsNested<A> addNewItem();
    public KubernetesClusterRoleBindingListFluent.ItemsNested<A> addNewItemLike(KubernetesClusterRoleBinding item);
    public KubernetesClusterRoleBindingListFluent.ItemsNested<A> setNewItemLike(int index,KubernetesClusterRoleBinding item);
    public KubernetesClusterRoleBindingListFluent.ItemsNested<A> editItem(int index);
    public KubernetesClusterRoleBindingListFluent.ItemsNested<A> editFirstItem();
    public KubernetesClusterRoleBindingListFluent.ItemsNested<A> editLastItem();
    public KubernetesClusterRoleBindingListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<KubernetesClusterRoleBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);
    public KubernetesClusterRoleBindingListFluent.MetadataNested<A> withNewMetadata();
    public KubernetesClusterRoleBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public KubernetesClusterRoleBindingListFluent.MetadataNested<A> editMetadata();
    public KubernetesClusterRoleBindingListFluent.MetadataNested<A> editOrNewMetadata();
    public KubernetesClusterRoleBindingListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,KubernetesClusterRoleBindingFluent<KubernetesClusterRoleBindingListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<KubernetesClusterRoleBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
