/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.NamedExtension;
import io.fabric8.kubernetes.api.model.NamedExtensionBuilder;
import io.fabric8.kubernetes.api.model.NamedExtensionFluentImpl;
import io.fabric8.kubernetes.api.model.Preferences;
import io.fabric8.kubernetes.api.model.PreferencesFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PreferencesFluentImpl<A extends PreferencesFluent<A>>
extends BaseFluent<A>
implements PreferencesFluent<A> {
    private Boolean colors;
    private List<NamedExtensionBuilder> extensions = new ArrayList<NamedExtensionBuilder>();

    public PreferencesFluentImpl() {
    }

    public PreferencesFluentImpl(Preferences instance) {
        this.withColors(instance.getColors());
        this.withExtensions(instance.getExtensions());
    }

    @Override
    public Boolean isColors() {
        return this.colors;
    }

    @Override
    public A withColors(Boolean colors) {
        this.colors = colors;
        return (A)this;
    }

    @Override
    public Boolean hasColors() {
        return this.colors != null;
    }

    @Override
    public A addToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.extensions.add(index >= 0 ? index : this.extensions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToExtensions(int index, NamedExtension item) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.extensions.size()) {
            this.extensions.add(builder);
        } else {
            this.extensions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToExtensions(NamedExtension ... items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtensions(Collection<NamedExtension> items) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        }
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.add(builder);
            this.extensions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtensions(NamedExtension ... items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtensions(Collection<NamedExtension> items) {
        for (NamedExtension item : items) {
            NamedExtensionBuilder builder = new NamedExtensionBuilder(item);
            this._visitables.remove(builder);
            if (this.extensions == null) continue;
            this.extensions.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<NamedExtension> getExtensions() {
        return PreferencesFluentImpl.build(this.extensions);
    }

    @Override
    public List<NamedExtension> buildExtensions() {
        return PreferencesFluentImpl.build(this.extensions);
    }

    @Override
    public NamedExtension buildExtension(int index) {
        return this.extensions.get(index).build();
    }

    @Override
    public NamedExtension buildFirstExtension() {
        return this.extensions.get(0).build();
    }

    @Override
    public NamedExtension buildLastExtension() {
        return this.extensions.get(this.extensions.size() - 1).build();
    }

    @Override
    public NamedExtension buildMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        for (NamedExtensionBuilder item : this.extensions) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withExtensions(List<NamedExtension> extensions) {
        if (this.extensions == null) {
            this.extensions = new ArrayList<NamedExtensionBuilder>();
        } else {
            this._visitables.removeAll(this.extensions);
            this.extensions.clear();
        }
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withExtensions(NamedExtension ... extensions) {
        this.extensions.clear();
        if (extensions != null) {
            for (NamedExtension item : extensions) {
                this.addToExtensions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtensions() {
        return this.extensions != null && !this.extensions.isEmpty();
    }

    @Override
    public PreferencesFluent.ExtensionsNested<A> addNewExtension() {
        return new ExtensionsNestedImpl();
    }

    @Override
    public PreferencesFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item) {
        return new ExtensionsNestedImpl(-1, item);
    }

    @Override
    public PreferencesFluent.ExtensionsNested<A> setNewExtensionLike(int index, NamedExtension item) {
        return new ExtensionsNestedImpl(index, item);
    }

    @Override
    public PreferencesFluent.ExtensionsNested<A> editExtension(int index) {
        if (this.extensions.size() <= index) {
            throw new RuntimeException("Can't edit extensions. Index exceeds size.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public PreferencesFluent.ExtensionsNested<A> editFirstExtension() {
        if (this.extensions.size() == 0) {
            throw new RuntimeException("Can't edit first extensions. The list is empty.");
        }
        return this.setNewExtensionLike(0, this.buildExtension(0));
    }

    @Override
    public PreferencesFluent.ExtensionsNested<A> editLastExtension() {
        int index = this.extensions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last extensions. The list is empty.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    @Override
    public PreferencesFluent.ExtensionsNested<A> editMatchingExtension(Predicate<NamedExtensionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.extensions.size(); ++i) {
            if (!predicate.apply(this.extensions.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching extensions. No match found.");
        }
        return this.setNewExtensionLike(index, this.buildExtension(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PreferencesFluentImpl that = (PreferencesFluentImpl)o;
        if (this.colors != null ? !this.colors.equals(that.colors) : that.colors != null) {
            return false;
        }
        return !(this.extensions != null ? !this.extensions.equals(that.extensions) : that.extensions != null);
    }

    public class ExtensionsNestedImpl<N>
    extends NamedExtensionFluentImpl<PreferencesFluent.ExtensionsNested<N>>
    implements PreferencesFluent.ExtensionsNested<N>,
    Nested<N> {
        private final NamedExtensionBuilder builder;
        private final int index;

        ExtensionsNestedImpl(int index, NamedExtension item) {
            this.index = index;
            this.builder = new NamedExtensionBuilder(this, item);
        }

        ExtensionsNestedImpl() {
            this.index = -1;
            this.builder = new NamedExtensionBuilder(this);
        }

        @Override
        public N and() {
            return (N)PreferencesFluentImpl.this.setToExtensions(this.index, this.builder.build());
        }

        @Override
        public N endExtension() {
            return this.and();
        }
    }
}

