/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.KubernetesClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.KubernetesClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.KubernetesClusterRoleBindingFluentImpl;

public class KubernetesClusterRoleBindingBuilder
extends KubernetesClusterRoleBindingFluentImpl<KubernetesClusterRoleBindingBuilder>
implements VisitableBuilder<KubernetesClusterRoleBinding, KubernetesClusterRoleBindingBuilder> {
    KubernetesClusterRoleBindingFluent<?> fluent;
    Boolean validationEnabled;

    public KubernetesClusterRoleBindingBuilder() {
        this(true);
    }

    public KubernetesClusterRoleBindingBuilder(Boolean validationEnabled) {
        this(new KubernetesClusterRoleBinding(), validationEnabled);
    }

    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new KubernetesClusterRoleBinding(), validationEnabled);
    }

    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent, KubernetesClusterRoleBinding instance) {
        this(fluent, instance, true);
    }

    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBindingFluent<?> fluent, KubernetesClusterRoleBinding instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withRoleRef(instance.getRoleRef());
        fluent.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBinding instance) {
        this(instance, (Boolean)true);
    }

    public KubernetesClusterRoleBindingBuilder(KubernetesClusterRoleBinding instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public KubernetesClusterRoleBinding build() {
        KubernetesClusterRoleBinding buildable = new KubernetesClusterRoleBinding(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getRoleRef(), this.fluent.getSubjects());
        ValidationUtils.validate(buildable);
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesClusterRoleBindingBuilder that = (KubernetesClusterRoleBindingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

