package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import javax.validation.constraints.NotNull;

public class TypeMetaFluentImpl<A extends TypeMetaFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements TypeMetaFluent<A>{

    private String apiVersion;
    private String kind;

    public TypeMetaFluentImpl(){
    }
    public TypeMetaFluentImpl(TypeMeta instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            TypeMetaFluentImpl that = (TypeMetaFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            return true;
    }




}
