package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface ClusterPolicyListFluent<A extends ClusterPolicyListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,ClusterPolicy item);
    public A setToItems(int index,ClusterPolicy item);
    public A addToItems(ClusterPolicy... items);
    public A addAllToItems(Collection<ClusterPolicy> items);
    public A removeFromItems(ClusterPolicy... items);
    public A removeAllFromItems(Collection<ClusterPolicy> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 */
@Deprecated public List<ClusterPolicy> getItems();
    public List<ClusterPolicy> buildItems();
    public ClusterPolicy buildItem(int index);
    public ClusterPolicy buildFirstItem();
    public ClusterPolicy buildLastItem();
    public ClusterPolicy buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterPolicyBuilder> predicate);
    public A withItems(List<ClusterPolicy> items);
    public A withItems(ClusterPolicy... items);
    public Boolean hasItems();
    public ClusterPolicyListFluent.ItemsNested<A> addNewItem();
    public ClusterPolicyListFluent.ItemsNested<A> addNewItemLike(ClusterPolicy item);
    public ClusterPolicyListFluent.ItemsNested<A> setNewItemLike(int index,ClusterPolicy item);
    public ClusterPolicyListFluent.ItemsNested<A> editItem(int index);
    public ClusterPolicyListFluent.ItemsNested<A> editFirstItem();
    public ClusterPolicyListFluent.ItemsNested<A> editLastItem();
    public ClusterPolicyListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<ClusterPolicyBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);
    public ClusterPolicyListFluent.MetadataNested<A> withNewMetadata();
    public ClusterPolicyListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ClusterPolicyListFluent.MetadataNested<A> editMetadata();
    public ClusterPolicyListFluent.MetadataNested<A> editOrNewMetadata();
    public ClusterPolicyListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ClusterPolicyFluent<ClusterPolicyListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ClusterPolicyListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
