package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import java.lang.Deprecated;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface PolicyBindingListFluent<A extends PolicyBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A addToItems(int index,PolicyBinding item);
    public A setToItems(int index,PolicyBinding item);
    public A addToItems(PolicyBinding... items);
    public A addAllToItems(Collection<PolicyBinding> items);
    public A removeFromItems(PolicyBinding... items);
    public A removeAllFromItems(Collection<PolicyBinding> items);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<PolicyBinding> getItems();
    public List<PolicyBinding> buildItems();
    public PolicyBinding buildItem(int index);
    public PolicyBinding buildFirstItem();
    public PolicyBinding buildLastItem();
    public PolicyBinding buildMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PolicyBindingBuilder> predicate);
    public A withItems(List<PolicyBinding> items);
    public A withItems(PolicyBinding... items);
    public Boolean hasItems();
    public PolicyBindingListFluent.ItemsNested<A> addNewItem();
    public PolicyBindingListFluent.ItemsNested<A> addNewItemLike(PolicyBinding item);
    public PolicyBindingListFluent.ItemsNested<A> setNewItemLike(int index,PolicyBinding item);
    public PolicyBindingListFluent.ItemsNested<A> editItem(int index);
    public PolicyBindingListFluent.ItemsNested<A> editFirstItem();
    public PolicyBindingListFluent.ItemsNested<A> editLastItem();
    public PolicyBindingListFluent.ItemsNested<A> editMatchingItem(io.fabric8.kubernetes.api.builder.Predicate<PolicyBindingBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ListMeta getMetadata();
    public ListMeta buildMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,String resourceVersion,String selfLink);
    public PolicyBindingListFluent.MetadataNested<A> withNewMetadata();
    public PolicyBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PolicyBindingListFluent.MetadataNested<A> editMetadata();
    public PolicyBindingListFluent.MetadataNested<A> editOrNewMetadata();
    public PolicyBindingListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PolicyBindingFluent<PolicyBindingListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<PolicyBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
