package io.fabric8.kubernetes.api.model;

import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;

public interface HorizontalPodAutoscalerStatusFluent<A extends HorizontalPodAutoscalerStatusFluent<A>> extends Fluent<A>{


    public Integer getCurrentCPUUtilizationPercentage();
    public A withCurrentCPUUtilizationPercentage(Integer currentCPUUtilizationPercentage);
    public Boolean hasCurrentCPUUtilizationPercentage();
    public A withNewCurrentCPUUtilizationPercentage(String arg1);
    public A withNewCurrentCPUUtilizationPercentage(int arg1);
    public Integer getCurrentReplicas();
    public A withCurrentReplicas(Integer currentReplicas);
    public Boolean hasCurrentReplicas();
    public A withNewCurrentReplicas(String arg1);
    public A withNewCurrentReplicas(int arg1);
    public Integer getDesiredReplicas();
    public A withDesiredReplicas(Integer desiredReplicas);
    public Boolean hasDesiredReplicas();
    public A withNewDesiredReplicas(String arg1);
    public A withNewDesiredReplicas(int arg1);
    public String getLastScaleTime();
    public A withLastScaleTime(String lastScaleTime);
    public Boolean hasLastScaleTime();
    public Long getObservedGeneration();
    public A withObservedGeneration(Long observedGeneration);
    public Boolean hasObservedGeneration();
    public A withNewObservedGeneration(String arg1);
    public A withNewObservedGeneration(long arg1);



}
