package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class NodeConfigSourceFluentImpl<A extends NodeConfigSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements NodeConfigSourceFluent<A>{

    private String apiVersion;
    private ObjectReferenceBuilder configMapRef;
    private String kind;

    public NodeConfigSourceFluentImpl(){
    }
    public NodeConfigSourceFluentImpl(NodeConfigSource instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withConfigMapRef(instance.getConfigMapRef()); 
            this.withKind(instance.getKind()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    
/**
 * This method has been deprecated, please use method buildConfigMapRef instead.
 * @return The buildable object.
 */
@Deprecated public ObjectReference getConfigMapRef(){
            return this.configMapRef!=null?this.configMapRef.build():null;
    }

    public ObjectReference buildConfigMapRef(){
            return this.configMapRef!=null?this.configMapRef.build():null;
    }

    public A withConfigMapRef(ObjectReference configMapRef){
            _visitables.remove(this.configMapRef);
            if (configMapRef!=null){ this.configMapRef= new ObjectReferenceBuilder(configMapRef); _visitables.add(this.configMapRef);} return (A) this;
    }

    public Boolean hasConfigMapRef(){
            return this.configMapRef != null;
    }

    public NodeConfigSourceFluent.ConfigMapRefNested<A> withNewConfigMapRef(){
            return new ConfigMapRefNestedImpl();
    }

    public NodeConfigSourceFluent.ConfigMapRefNested<A> withNewConfigMapRefLike(ObjectReference item){
            return new ConfigMapRefNestedImpl(item);
    }

    public NodeConfigSourceFluent.ConfigMapRefNested<A> editConfigMapRef(){
            return withNewConfigMapRefLike(getConfigMapRef());
    }

    public NodeConfigSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRef(){
            return withNewConfigMapRefLike(getConfigMapRef() != null ? getConfigMapRef(): new ObjectReferenceBuilder().build());
    }

    public NodeConfigSourceFluent.ConfigMapRefNested<A> editOrNewConfigMapRefLike(ObjectReference item){
            return withNewConfigMapRefLike(getConfigMapRef() != null ? getConfigMapRef(): item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            NodeConfigSourceFluentImpl that = (NodeConfigSourceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (configMapRef != null ? !configMapRef.equals(that.configMapRef) :that.configMapRef != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            return true;
    }


    public class ConfigMapRefNestedImpl<N> extends ObjectReferenceFluentImpl<NodeConfigSourceFluent.ConfigMapRefNested<N>> implements NodeConfigSourceFluent.ConfigMapRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            ConfigMapRefNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            ConfigMapRefNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) NodeConfigSourceFluentImpl.this.withConfigMapRef(builder.build());
    }
    public N endConfigMapRef(){
            return and();
    }

}


}
