package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Deprecated;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class PodSecurityContextFluentImpl<A extends PodSecurityContextFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements PodSecurityContextFluent<A>{

    private Long fsGroup;
    private Boolean runAsNonRoot;
    private Long runAsUser;
    private SELinuxOptionsBuilder seLinuxOptions;
    private List<Long> supplementalGroups;

    public PodSecurityContextFluentImpl(){
    }
    public PodSecurityContextFluentImpl(PodSecurityContext instance){
            this.withFsGroup(instance.getFsGroup()); 
            this.withRunAsNonRoot(instance.getRunAsNonRoot()); 
            this.withRunAsUser(instance.getRunAsUser()); 
            this.withSeLinuxOptions(instance.getSeLinuxOptions()); 
            this.withSupplementalGroups(instance.getSupplementalGroups()); 
    }

    public Long getFsGroup(){
            return this.fsGroup;
    }

    public A withFsGroup(Long fsGroup){
            this.fsGroup=fsGroup; return (A) this;
    }

    public Boolean hasFsGroup(){
            return this.fsGroup != null;
    }

    public A withNewFsGroup(String arg1){
            return (A)withFsGroup(new Long(arg1));
    }

    public A withNewFsGroup(long arg1){
            return (A)withFsGroup(new Long(arg1));
    }

    public Boolean isRunAsNonRoot(){
            return this.runAsNonRoot;
    }

    public A withRunAsNonRoot(Boolean runAsNonRoot){
            this.runAsNonRoot=runAsNonRoot; return (A) this;
    }

    public Boolean hasRunAsNonRoot(){
            return this.runAsNonRoot != null;
    }

    public A withNewRunAsNonRoot(String arg1){
            return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public A withNewRunAsNonRoot(boolean arg1){
            return (A)withRunAsNonRoot(new Boolean(arg1));
    }

    public Long getRunAsUser(){
            return this.runAsUser;
    }

    public A withRunAsUser(Long runAsUser){
            this.runAsUser=runAsUser; return (A) this;
    }

    public Boolean hasRunAsUser(){
            return this.runAsUser != null;
    }

    public A withNewRunAsUser(String arg1){
            return (A)withRunAsUser(new Long(arg1));
    }

    public A withNewRunAsUser(long arg1){
            return (A)withRunAsUser(new Long(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSeLinuxOptions instead.
 * @return The buildable object.
 */
@Deprecated public SELinuxOptions getSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public SELinuxOptions buildSeLinuxOptions(){
            return this.seLinuxOptions!=null?this.seLinuxOptions.build():null;
    }

    public A withSeLinuxOptions(SELinuxOptions seLinuxOptions){
            _visitables.remove(this.seLinuxOptions);
            if (seLinuxOptions!=null){ this.seLinuxOptions= new SELinuxOptionsBuilder(seLinuxOptions); _visitables.add(this.seLinuxOptions);} return (A) this;
    }

    public Boolean hasSeLinuxOptions(){
            return this.seLinuxOptions != null;
    }

    public A withNewSeLinuxOptions(String level,String role,String type,String user){
            return (A)withSeLinuxOptions(new SELinuxOptions(level, role, type, user));
    }

    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptions(){
            return new SeLinuxOptionsNestedImpl();
    }

    public PodSecurityContextFluent.SeLinuxOptionsNested<A> withNewSeLinuxOptionsLike(SELinuxOptions item){
            return new SeLinuxOptionsNestedImpl(item);
    }

    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions());
    }

    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptions(){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): new SELinuxOptionsBuilder().build());
    }

    public PodSecurityContextFluent.SeLinuxOptionsNested<A> editOrNewSeLinuxOptionsLike(SELinuxOptions item){
            return withNewSeLinuxOptionsLike(getSeLinuxOptions() != null ? getSeLinuxOptions(): item);
    }

    public A addToSupplementalGroups(int index,Long item){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            this.supplementalGroups.add(index, item);
            return (A)this;
    }

    public A setToSupplementalGroups(int index,Long item){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            this.supplementalGroups.set(index, item); return (A)this;
    }

    public A addToSupplementalGroups(Long... items){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
    }

    public A addAllToSupplementalGroups(Collection<Long> items){
            if (this.supplementalGroups == null) {this.supplementalGroups = new ArrayList<Long>();}
            for (Long item : items) {this.supplementalGroups.add(item);} return (A)this;
    }

    public A removeFromSupplementalGroups(Long... items){
            for (Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
    }

    public A removeAllFromSupplementalGroups(Collection<Long> items){
            for (Long item : items) {if (this.supplementalGroups!= null){ this.supplementalGroups.remove(item);}} return (A)this;
    }

    public List<Long> getSupplementalGroups(){
            return this.supplementalGroups;
    }

    public Long getSupplementalGroup(int index){
            return this.supplementalGroups.get(index);
    }

    public Long getFirstSupplementalGroup(){
            return this.supplementalGroups.get(0);
    }

    public Long getLastSupplementalGroup(){
            return this.supplementalGroups.get(supplementalGroups.size() - 1);
    }

    public Long getMatchingSupplementalGroup(io.fabric8.kubernetes.api.builder.Predicate<Long> predicate){
            for (Long item: supplementalGroups) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withSupplementalGroups(List<Long> supplementalGroups){
            if (this.supplementalGroups != null) { _visitables.removeAll(this.supplementalGroups);}
            if (supplementalGroups != null) {this.supplementalGroups = new ArrayList<Long>(); for (Long item : supplementalGroups){this.addToSupplementalGroups(item);}} else { this.supplementalGroups = new ArrayList<Long>();} return (A) this;
    }

    public A withSupplementalGroups(Long... supplementalGroups){
            if (this.supplementalGroups != null) {this.supplementalGroups.clear();}
            if (supplementalGroups != null) {for (Long item :supplementalGroups){ this.addToSupplementalGroups(item);}} return (A) this;
    }

    public Boolean hasSupplementalGroups(){
            return supplementalGroups != null && !supplementalGroups.isEmpty();
    }

    public A addNewSupplementalGroup(String arg1){
            return (A)addToSupplementalGroups(new Long(arg1));
    }

    public A addNewSupplementalGroup(long arg1){
            return (A)addToSupplementalGroups(new Long(arg1));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PodSecurityContextFluentImpl that = (PodSecurityContextFluentImpl) o;
            if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
            if (runAsNonRoot != null ? !runAsNonRoot.equals(that.runAsNonRoot) :that.runAsNonRoot != null) return false;
            if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
            if (seLinuxOptions != null ? !seLinuxOptions.equals(that.seLinuxOptions) :that.seLinuxOptions != null) return false;
            if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
            return true;
    }


    public class SeLinuxOptionsNestedImpl<N> extends SELinuxOptionsFluentImpl<PodSecurityContextFluent.SeLinuxOptionsNested<N>> implements PodSecurityContextFluent.SeLinuxOptionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final SELinuxOptionsBuilder builder;
    
            SeLinuxOptionsNestedImpl(SELinuxOptions item){
                    this.builder = new SELinuxOptionsBuilder(this, item);
            }
            SeLinuxOptionsNestedImpl(){
                    this.builder = new SELinuxOptionsBuilder(this);
            }
    
    public N and(){
            return (N) PodSecurityContextFluentImpl.this.withSeLinuxOptions(builder.build());
    }
    public N endSeLinuxOptions(){
            return and();
    }

}


}
