package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class KubernetesRoleBindingBuilder extends KubernetesRoleBindingFluentImpl<KubernetesRoleBindingBuilder> implements VisitableBuilder<KubernetesRoleBinding,KubernetesRoleBindingBuilder>{

    KubernetesRoleBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesRoleBindingBuilder(){
            this(true);
    }
    public KubernetesRoleBindingBuilder(Boolean validationEnabled){
            this(new KubernetesRoleBinding(), validationEnabled);
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesRoleBinding(), validationEnabled);
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent,KubernetesRoleBinding instance){
            this(fluent, instance, true);
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent,KubernetesRoleBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoleRef(instance.getRoleRef()); 
            fluent.withSubjects(instance.getSubjects()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBinding instance){
            this(instance,true);
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesRoleBindingBuilder(Validator validator){
            this(new KubernetesRoleBinding(), true);
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBindingFluent<?> fluent,KubernetesRoleBinding instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoleRef(instance.getRoleRef()); 
            fluent.withSubjects(instance.getSubjects()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public KubernetesRoleBindingBuilder(KubernetesRoleBinding instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoleRef(instance.getRoleRef()); 
            this.withSubjects(instance.getSubjects()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public KubernetesRoleBinding build(){
            KubernetesRoleBinding buildable = new KubernetesRoleBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRoleRef(),fluent.getSubjects());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesRoleBindingBuilder that = (KubernetesRoleBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
