package io.fabric8.kubernetes.api.model.storage;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

public class StorageClassFluentImpl<A extends StorageClassFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements StorageClassFluent<A>{

    private Boolean allowVolumeExpansion;
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<String> mountOptions;
    private Map<String,String> parameters;
    private String provisioner;
    private String reclaimPolicy;
    private String volumeBindingMode;

    public StorageClassFluentImpl(){
    }
    public StorageClassFluentImpl(StorageClass instance){
            this.withAllowVolumeExpansion(instance.getAllowVolumeExpansion()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withMountOptions(instance.getMountOptions()); 
            this.withParameters(instance.getParameters()); 
            this.withProvisioner(instance.getProvisioner()); 
            this.withReclaimPolicy(instance.getReclaimPolicy()); 
            this.withVolumeBindingMode(instance.getVolumeBindingMode()); 
    }

    public Boolean isAllowVolumeExpansion(){
            return this.allowVolumeExpansion;
    }

    public A withAllowVolumeExpansion(Boolean allowVolumeExpansion){
            this.allowVolumeExpansion=allowVolumeExpansion; return (A) this;
    }

    public Boolean hasAllowVolumeExpansion(){
            return this.allowVolumeExpansion != null;
    }

    public A withNewAllowVolumeExpansion(String arg1){
            return (A)withAllowVolumeExpansion(new Boolean(arg1));
    }

    public A withNewAllowVolumeExpansion(boolean arg1){
            return (A)withAllowVolumeExpansion(new Boolean(arg1));
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion(){
            return this.apiVersion != null;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean hasKind(){
            return this.kind != null;
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata(){
            return this.metadata != null;
    }

    public StorageClassFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public StorageClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public StorageClassFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public StorageClassFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public StorageClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToMountOptions(int index,String item){
            if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
            this.mountOptions.add(index, item);
            return (A)this;
    }

    public A setToMountOptions(int index,String item){
            if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
            this.mountOptions.set(index, item); return (A)this;
    }

    public A addToMountOptions(String... items){
            if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
            for (String item : items) {this.mountOptions.add(item);} return (A)this;
    }

    public A addAllToMountOptions(Collection<String> items){
            if (this.mountOptions == null) {this.mountOptions = new ArrayList<String>();}
            for (String item : items) {this.mountOptions.add(item);} return (A)this;
    }

    public A removeFromMountOptions(String... items){
            for (String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
    }

    public A removeAllFromMountOptions(Collection<String> items){
            for (String item : items) {if (this.mountOptions!= null){ this.mountOptions.remove(item);}} return (A)this;
    }

    public List<String> getMountOptions(){
            return this.mountOptions;
    }

    public String getMountOption(int index){
            return this.mountOptions.get(index);
    }

    public String getFirstMountOption(){
            return this.mountOptions.get(0);
    }

    public String getLastMountOption(){
            return this.mountOptions.get(mountOptions.size() - 1);
    }

    public String getMatchingMountOption(io.fabric8.kubernetes.api.builder.Predicate<String> predicate){
            for (String item: mountOptions) { if(predicate.apply(item)){return item;} } return null;
    }

    public A withMountOptions(List<String> mountOptions){
            if (this.mountOptions != null) { _visitables.removeAll(this.mountOptions);}
            if (mountOptions != null) {this.mountOptions = new ArrayList<String>(); for (String item : mountOptions){this.addToMountOptions(item);}} else { this.mountOptions = new ArrayList<String>();} return (A) this;
    }

    public A withMountOptions(String... mountOptions){
            if (this.mountOptions != null) {this.mountOptions.clear();}
            if (mountOptions != null) {for (String item :mountOptions){ this.addToMountOptions(item);}} return (A) this;
    }

    public Boolean hasMountOptions(){
            return mountOptions != null && !mountOptions.isEmpty();
    }

    public A addToParameters(String key,String value){
            if(this.parameters == null && key != null && value != null) { this.parameters = new LinkedHashMap<String,String>(); }
            if(key != null && value != null) {this.parameters.put(key, value);} return (A)this;
    }

    public A addToParameters(Map<String,String> map){
            if(this.parameters == null && map != null) { this.parameters = new LinkedHashMap<String,String>(); }
            if(map != null) { this.parameters.putAll(map);} return (A)this;
    }

    public A removeFromParameters(String key){
            if(this.parameters == null) { return (A) this; }
            if(key != null && this.parameters != null) {this.parameters.remove(key);} return (A)this;
    }

    public A removeFromParameters(Map<String,String> map){
            if(this.parameters == null) { return (A) this; }
            if(map != null) { for(Object key : map.keySet()) {if (this.parameters != null){this.parameters.remove(key);}}} return (A)this;
    }

    public Map<String,String> getParameters(){
            return this.parameters;
    }

    public A withParameters(Map<String,String> parameters){
            if (parameters == null) { this.parameters =  new LinkedHashMap<String,String>();} else {this.parameters = new LinkedHashMap<String,String>(parameters);} return (A) this;
    }

    public Boolean hasParameters(){
            return this.parameters != null;
    }

    public String getProvisioner(){
            return this.provisioner;
    }

    public A withProvisioner(String provisioner){
            this.provisioner=provisioner; return (A) this;
    }

    public Boolean hasProvisioner(){
            return this.provisioner != null;
    }

    public String getReclaimPolicy(){
            return this.reclaimPolicy;
    }

    public A withReclaimPolicy(String reclaimPolicy){
            this.reclaimPolicy=reclaimPolicy; return (A) this;
    }

    public Boolean hasReclaimPolicy(){
            return this.reclaimPolicy != null;
    }

    public String getVolumeBindingMode(){
            return this.volumeBindingMode;
    }

    public A withVolumeBindingMode(String volumeBindingMode){
            this.volumeBindingMode=volumeBindingMode; return (A) this;
    }

    public Boolean hasVolumeBindingMode(){
            return this.volumeBindingMode != null;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            StorageClassFluentImpl that = (StorageClassFluentImpl) o;
            if (allowVolumeExpansion != null ? !allowVolumeExpansion.equals(that.allowVolumeExpansion) :that.allowVolumeExpansion != null) return false;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (mountOptions != null ? !mountOptions.equals(that.mountOptions) :that.mountOptions != null) return false;
            if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
            if (provisioner != null ? !provisioner.equals(that.provisioner) :that.provisioner != null) return false;
            if (reclaimPolicy != null ? !reclaimPolicy.equals(that.reclaimPolicy) :that.reclaimPolicy != null) return false;
            if (volumeBindingMode != null ? !volumeBindingMode.equals(that.volumeBindingMode) :that.volumeBindingMode != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<StorageClassFluent.MetadataNested<N>> implements StorageClassFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) StorageClassFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
