package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ClusterPolicyBindingBuilder extends ClusterPolicyBindingFluentImpl<ClusterPolicyBindingBuilder> implements VisitableBuilder<ClusterPolicyBinding,ClusterPolicyBindingBuilder>{

    ClusterPolicyBindingFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterPolicyBindingBuilder(){
            this(true);
    }
    public ClusterPolicyBindingBuilder(Boolean validationEnabled){
            this(new ClusterPolicyBinding(), validationEnabled);
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBindingFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBindingFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterPolicyBinding(), validationEnabled);
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBindingFluent<?> fluent,ClusterPolicyBinding instance){
            this(fluent, instance, true);
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBindingFluent<?> fluent,ClusterPolicyBinding instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withPolicyRef(instance.getPolicyRef()); 
            fluent.withRoleBindings(instance.getRoleBindings()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBinding instance){
            this(instance,true);
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBinding instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withPolicyRef(instance.getPolicyRef()); 
            this.withRoleBindings(instance.getRoleBindings()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterPolicyBindingBuilder(Validator validator){
            this(new ClusterPolicyBinding(), true);
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBindingFluent<?> fluent,ClusterPolicyBinding instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withPolicyRef(instance.getPolicyRef()); 
            fluent.withRoleBindings(instance.getRoleBindings()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ClusterPolicyBindingBuilder(ClusterPolicyBinding instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withPolicyRef(instance.getPolicyRef()); 
            this.withRoleBindings(instance.getRoleBindings()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ClusterPolicyBinding build(){
            ClusterPolicyBinding buildable = new ClusterPolicyBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getPolicyRef(),fluent.getRoleBindings());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterPolicyBindingBuilder that = (ClusterPolicyBindingBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
