package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ClusterPolicyBuilder extends ClusterPolicyFluentImpl<ClusterPolicyBuilder> implements VisitableBuilder<ClusterPolicy,ClusterPolicyBuilder>{

    ClusterPolicyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ClusterPolicyBuilder(){
            this(true);
    }
    public ClusterPolicyBuilder(Boolean validationEnabled){
            this(new ClusterPolicy(), validationEnabled);
    }
    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent){
            this(fluent, true);
    }
    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ClusterPolicy(), validationEnabled);
    }
    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent,ClusterPolicy instance){
            this(fluent, instance, true);
    }
    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent,ClusterPolicy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoles(instance.getRoles()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterPolicyBuilder(ClusterPolicy instance){
            this(instance,true);
    }
    public ClusterPolicyBuilder(ClusterPolicy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
            this.validationEnabled = validationEnabled; 
    }
    public ClusterPolicyBuilder(Validator validator){
            this(new ClusterPolicy(), true);
    }
    public ClusterPolicyBuilder(ClusterPolicyFluent<?> fluent,ClusterPolicy instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoles(instance.getRoles()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ClusterPolicyBuilder(ClusterPolicy instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public ClusterPolicy build(){
            ClusterPolicy buildable = new ClusterPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getRoles());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterPolicyBuilder that = (ClusterPolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
