package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class PolicyBuilder extends PolicyFluentImpl<PolicyBuilder> implements VisitableBuilder<Policy,PolicyBuilder>{

    PolicyFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PolicyBuilder(){
            this(true);
    }
    public PolicyBuilder(Boolean validationEnabled){
            this(new Policy(), validationEnabled);
    }
    public PolicyBuilder(PolicyFluent<?> fluent){
            this(fluent, true);
    }
    public PolicyBuilder(PolicyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Policy(), validationEnabled);
    }
    public PolicyBuilder(PolicyFluent<?> fluent,Policy instance){
            this(fluent, instance, true);
    }
    public PolicyBuilder(PolicyFluent<?> fluent,Policy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoles(instance.getRoles()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyBuilder(Policy instance){
            this(instance,true);
    }
    public PolicyBuilder(Policy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
            this.validationEnabled = validationEnabled; 
    }
    public PolicyBuilder(Validator validator){
            this(new Policy(), true);
    }
    public PolicyBuilder(PolicyFluent<?> fluent,Policy instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastModified(instance.getLastModified()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRoles(instance.getRoles()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public PolicyBuilder(Policy instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withLastModified(instance.getLastModified()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRoles(instance.getRoles()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Policy build(){
            Policy buildable = new Policy(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getRoles());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            PolicyBuilder that = (PolicyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
