package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class RoleBindingRestrictionSpecBuilder extends RoleBindingRestrictionSpecFluentImpl<RoleBindingRestrictionSpecBuilder> implements VisitableBuilder<RoleBindingRestrictionSpec,RoleBindingRestrictionSpecBuilder>{

    RoleBindingRestrictionSpecFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public RoleBindingRestrictionSpecBuilder(){
            this(true);
    }
    public RoleBindingRestrictionSpecBuilder(Boolean validationEnabled){
            this(new RoleBindingRestrictionSpec(), validationEnabled);
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent){
            this(fluent, true);
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new RoleBindingRestrictionSpec(), validationEnabled);
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent,RoleBindingRestrictionSpec instance){
            this(fluent, instance, true);
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent,RoleBindingRestrictionSpec instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withGrouprestriction(instance.getGrouprestriction()); 
            fluent.withServiceaccountrestriction(instance.getServiceaccountrestriction()); 
            fluent.withUserrestriction(instance.getUserrestriction()); 
            this.validationEnabled = validationEnabled; 
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpec instance){
            this(instance,true);
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpec instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withGrouprestriction(instance.getGrouprestriction()); 
            this.withServiceaccountrestriction(instance.getServiceaccountrestriction()); 
            this.withUserrestriction(instance.getUserrestriction()); 
            this.validationEnabled = validationEnabled; 
    }
    public RoleBindingRestrictionSpecBuilder(Validator validator){
            this(new RoleBindingRestrictionSpec(), true);
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpecFluent<?> fluent,RoleBindingRestrictionSpec instance,Validator validator){
            this.fluent = fluent; 
            fluent.withGrouprestriction(instance.getGrouprestriction()); 
            fluent.withServiceaccountrestriction(instance.getServiceaccountrestriction()); 
            fluent.withUserrestriction(instance.getUserrestriction()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public RoleBindingRestrictionSpecBuilder(RoleBindingRestrictionSpec instance,Validator validator){
            this.fluent = this; 
            this.withGrouprestriction(instance.getGrouprestriction()); 
            this.withServiceaccountrestriction(instance.getServiceaccountrestriction()); 
            this.withUserrestriction(instance.getUserrestriction()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public RoleBindingRestrictionSpec build(){
            RoleBindingRestrictionSpec buildable = new RoleBindingRestrictionSpec(fluent.getGrouprestriction(),fluent.getServiceaccountrestriction(),fluent.getUserrestriction());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RoleBindingRestrictionSpecBuilder that = (RoleBindingRestrictionSpecBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
