package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class ScaleBuilder extends ScaleFluentImpl<ScaleBuilder> implements VisitableBuilder<Scale,ScaleBuilder>{

    ScaleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public ScaleBuilder(){
            this(true);
    }
    public ScaleBuilder(Boolean validationEnabled){
            this(new Scale(), validationEnabled);
    }
    public ScaleBuilder(ScaleFluent<?> fluent){
            this(fluent, true);
    }
    public ScaleBuilder(ScaleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Scale(), validationEnabled);
    }
    public ScaleBuilder(ScaleFluent<?> fluent,Scale instance){
            this(fluent, instance, true);
    }
    public ScaleBuilder(ScaleFluent<?> fluent,Scale instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ScaleBuilder(Scale instance){
            this(instance,true);
    }
    public ScaleBuilder(Scale instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validationEnabled = validationEnabled; 
    }
    public ScaleBuilder(Validator validator){
            this(new Scale(), true);
    }
    public ScaleBuilder(ScaleFluent<?> fluent,Scale instance,Validator validator){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withSpec(instance.getSpec()); 
            fluent.withStatus(instance.getStatus()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public ScaleBuilder(Scale instance,Validator validator){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withSpec(instance.getSpec()); 
            this.withStatus(instance.getStatus()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public Scale build(){
            Scale buildable = new Scale(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ScaleBuilder that = (ScaleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
