package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
import javax.validation.Validator;

public class KubernetesClusterRoleBuilder extends KubernetesClusterRoleFluentImpl<KubernetesClusterRoleBuilder> implements VisitableBuilder<KubernetesClusterRole,KubernetesClusterRoleBuilder>{

    KubernetesClusterRoleFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public KubernetesClusterRoleBuilder(){
            this(true);
    }
    public KubernetesClusterRoleBuilder(Boolean validationEnabled){
            this(new KubernetesClusterRole(), validationEnabled);
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent){
            this(fluent, true);
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new KubernetesClusterRole(), validationEnabled);
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent,KubernetesClusterRole instance){
            this(fluent, instance, true);
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent,KubernetesClusterRole instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withAggregationRule(instance.getAggregationRule()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRole instance){
            this(instance,true);
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRole instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withAggregationRule(instance.getAggregationRule()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRules(instance.getRules()); 
            this.validationEnabled = validationEnabled; 
    }
    public KubernetesClusterRoleBuilder(Validator validator){
            this(new KubernetesClusterRole(), true);
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRoleFluent<?> fluent,KubernetesClusterRole instance,Validator validator){
            this.fluent = fluent; 
            fluent.withAggregationRule(instance.getAggregationRule()); 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withRules(instance.getRules()); 
            this.validator = validator;
            this.validationEnabled = validator != null; 
    }
    public KubernetesClusterRoleBuilder(KubernetesClusterRole instance,Validator validator){
            this.fluent = this; 
            this.withAggregationRule(instance.getAggregationRule()); 
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withRules(instance.getRules()); 
            this.validator = validator; 
            this.validationEnabled = validator != null; 
    }

    public KubernetesClusterRole build(){
            KubernetesClusterRole buildable = new KubernetesClusterRole(fluent.getAggregationRule(),fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRules());
            if (validationEnabled) {io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable, validator);}
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            KubernetesClusterRoleBuilder that = (KubernetesClusterRoleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
