/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.rbac.KubernetesClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.KubernetesClusterRoleBindingFluent;
import io.fabric8.kubernetes.api.model.rbac.KubernetesRoleRef;
import io.fabric8.kubernetes.api.model.rbac.KubernetesRoleRefBuilder;
import io.fabric8.kubernetes.api.model.rbac.KubernetesRoleRefFluentImpl;
import io.fabric8.kubernetes.api.model.rbac.KubernetesSubject;
import io.fabric8.kubernetes.api.model.rbac.KubernetesSubjectBuilder;
import io.fabric8.kubernetes.api.model.rbac.KubernetesSubjectFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KubernetesClusterRoleBindingFluentImpl<A extends KubernetesClusterRoleBindingFluent<A>>
extends BaseFluent<A>
implements KubernetesClusterRoleBindingFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private KubernetesRoleRefBuilder roleRef;
    private List<KubernetesSubjectBuilder> subjects;

    public KubernetesClusterRoleBindingFluentImpl() {
    }

    public KubernetesClusterRoleBindingFluentImpl(KubernetesClusterRoleBinding instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withRoleRef(instance.getRoleRef());
        this.withSubjects(instance.getSubjects());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public KubernetesClusterRoleBindingFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public KubernetesClusterRoleBindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public KubernetesClusterRoleBindingFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public KubernetesClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public KubernetesClusterRoleBindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public KubernetesRoleRef getRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public KubernetesRoleRef buildRoleRef() {
        return this.roleRef != null ? this.roleRef.build() : null;
    }

    @Override
    public A withRoleRef(KubernetesRoleRef roleRef) {
        this._visitables.remove(this.roleRef);
        if (roleRef != null) {
            this.roleRef = new KubernetesRoleRefBuilder(roleRef);
            this._visitables.add(this.roleRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRoleRef() {
        return this.roleRef != null;
    }

    @Override
    public A withNewRoleRef(String apiGroup, String kind, String name) {
        return this.withRoleRef(new KubernetesRoleRef(apiGroup, kind, name));
    }

    @Override
    public KubernetesClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRef() {
        return new RoleRefNestedImpl();
    }

    @Override
    public KubernetesClusterRoleBindingFluent.RoleRefNested<A> withNewRoleRefLike(KubernetesRoleRef item) {
        return new RoleRefNestedImpl(item);
    }

    @Override
    public KubernetesClusterRoleBindingFluent.RoleRefNested<A> editRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef());
    }

    @Override
    public KubernetesClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRef() {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : new KubernetesRoleRefBuilder().build());
    }

    @Override
    public KubernetesClusterRoleBindingFluent.RoleRefNested<A> editOrNewRoleRefLike(KubernetesRoleRef item) {
        return this.withNewRoleRefLike(this.getRoleRef() != null ? this.getRoleRef() : item);
    }

    @Override
    public A addToSubjects(int index, KubernetesSubject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<KubernetesSubjectBuilder>();
        }
        KubernetesSubjectBuilder builder = new KubernetesSubjectBuilder(item);
        this._visitables.add(index >= 0 ? index : this._visitables.size(), builder);
        this.subjects.add(index >= 0 ? index : this.subjects.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSubjects(int index, KubernetesSubject item) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<KubernetesSubjectBuilder>();
        }
        KubernetesSubjectBuilder builder = new KubernetesSubjectBuilder(item);
        if (index < 0 || index >= this._visitables.size()) {
            this._visitables.add(builder);
        } else {
            this._visitables.set(index, builder);
        }
        if (index < 0 || index >= this.subjects.size()) {
            this.subjects.add(builder);
        } else {
            this.subjects.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSubjects(KubernetesSubject ... items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<KubernetesSubjectBuilder>();
        }
        for (KubernetesSubject item : items) {
            KubernetesSubjectBuilder builder = new KubernetesSubjectBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSubjects(Collection<KubernetesSubject> items) {
        if (this.subjects == null) {
            this.subjects = new ArrayList<KubernetesSubjectBuilder>();
        }
        for (KubernetesSubject item : items) {
            KubernetesSubjectBuilder builder = new KubernetesSubjectBuilder(item);
            this._visitables.add(builder);
            this.subjects.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSubjects(KubernetesSubject ... items) {
        for (KubernetesSubject item : items) {
            KubernetesSubjectBuilder builder = new KubernetesSubjectBuilder(item);
            this._visitables.remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSubjects(Collection<KubernetesSubject> items) {
        for (KubernetesSubject item : items) {
            KubernetesSubjectBuilder builder = new KubernetesSubjectBuilder(item);
            this._visitables.remove(builder);
            if (this.subjects == null) continue;
            this.subjects.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KubernetesSubject> getSubjects() {
        return KubernetesClusterRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public List<KubernetesSubject> buildSubjects() {
        return KubernetesClusterRoleBindingFluentImpl.build(this.subjects);
    }

    @Override
    public KubernetesSubject buildSubject(int index) {
        return this.subjects.get(index).build();
    }

    @Override
    public KubernetesSubject buildFirstSubject() {
        return this.subjects.get(0).build();
    }

    @Override
    public KubernetesSubject buildLastSubject() {
        return this.subjects.get(this.subjects.size() - 1).build();
    }

    @Override
    public KubernetesSubject buildMatchingSubject(Predicate<KubernetesSubjectBuilder> predicate) {
        for (KubernetesSubjectBuilder item : this.subjects) {
            if (!predicate.apply(item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public A withSubjects(List<KubernetesSubject> subjects) {
        if (this.subjects != null) {
            this._visitables.removeAll(this.subjects);
        }
        if (subjects != null) {
            this.subjects = new ArrayList<KubernetesSubjectBuilder>();
            for (KubernetesSubject item : subjects) {
                this.addToSubjects(item);
            }
        } else {
            this.subjects = new ArrayList<KubernetesSubjectBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withSubjects(KubernetesSubject ... subjects) {
        if (this.subjects != null) {
            this.subjects.clear();
        }
        if (subjects != null) {
            for (KubernetesSubject item : subjects) {
                this.addToSubjects(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSubjects() {
        return this.subjects != null && !this.subjects.isEmpty();
    }

    @Override
    public A addNewSubject(String apiGroup, String kind, String name, String namespace) {
        return this.addToSubjects(new KubernetesSubject(apiGroup, kind, name, namespace));
    }

    @Override
    public KubernetesClusterRoleBindingFluent.SubjectsNested<A> addNewSubject() {
        return new SubjectsNestedImpl();
    }

    @Override
    public KubernetesClusterRoleBindingFluent.SubjectsNested<A> addNewSubjectLike(KubernetesSubject item) {
        return new SubjectsNestedImpl(-1, item);
    }

    @Override
    public KubernetesClusterRoleBindingFluent.SubjectsNested<A> setNewSubjectLike(int index, KubernetesSubject item) {
        return new SubjectsNestedImpl(index, item);
    }

    @Override
    public KubernetesClusterRoleBindingFluent.SubjectsNested<A> editSubject(int index) {
        if (this.subjects.size() <= index) {
            throw new RuntimeException("Can't edit subjects. Index exceeds size.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public KubernetesClusterRoleBindingFluent.SubjectsNested<A> editFirstSubject() {
        if (this.subjects.size() == 0) {
            throw new RuntimeException("Can't edit first subjects. The list is empty.");
        }
        return this.setNewSubjectLike(0, this.buildSubject(0));
    }

    @Override
    public KubernetesClusterRoleBindingFluent.SubjectsNested<A> editLastSubject() {
        int index = this.subjects.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last subjects. The list is empty.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    @Override
    public KubernetesClusterRoleBindingFluent.SubjectsNested<A> editMatchingSubject(Predicate<KubernetesSubjectBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.subjects.size(); ++i) {
            if (!predicate.apply(this.subjects.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching subjects. No match found.");
        }
        return this.setNewSubjectLike(index, this.buildSubject(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KubernetesClusterRoleBindingFluentImpl that = (KubernetesClusterRoleBindingFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.roleRef != null ? !this.roleRef.equals(that.roleRef) : that.roleRef != null) {
            return false;
        }
        return !(this.subjects != null ? !this.subjects.equals(that.subjects) : that.subjects != null);
    }

    public class SubjectsNestedImpl<N>
    extends KubernetesSubjectFluentImpl<KubernetesClusterRoleBindingFluent.SubjectsNested<N>>
    implements KubernetesClusterRoleBindingFluent.SubjectsNested<N>,
    Nested<N> {
        private final KubernetesSubjectBuilder builder;
        private final int index;

        SubjectsNestedImpl(int index, KubernetesSubject item) {
            this.index = index;
            this.builder = new KubernetesSubjectBuilder(this, item);
        }

        SubjectsNestedImpl() {
            this.index = -1;
            this.builder = new KubernetesSubjectBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesClusterRoleBindingFluentImpl.this.setToSubjects(this.index, this.builder.build());
        }

        @Override
        public N endSubject() {
            return this.and();
        }
    }

    public class RoleRefNestedImpl<N>
    extends KubernetesRoleRefFluentImpl<KubernetesClusterRoleBindingFluent.RoleRefNested<N>>
    implements KubernetesClusterRoleBindingFluent.RoleRefNested<N>,
    Nested<N> {
        private final KubernetesRoleRefBuilder builder;

        RoleRefNestedImpl(KubernetesRoleRef item) {
            this.builder = new KubernetesRoleRefBuilder(this, item);
        }

        RoleRefNestedImpl() {
            this.builder = new KubernetesRoleRefBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesClusterRoleBindingFluentImpl.this.withRoleRef(this.builder.build());
        }

        @Override
        public N endRoleRef() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<KubernetesClusterRoleBindingFluent.MetadataNested<N>>
    implements KubernetesClusterRoleBindingFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)KubernetesClusterRoleBindingFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

