/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.rbac.Subject;
import io.fabric8.kubernetes.api.model.rbac.SubjectFluent;
import io.fabric8.kubernetes.api.model.rbac.SubjectFluentImpl;
import javax.validation.Validator;

public class SubjectBuilder
extends SubjectFluentImpl<SubjectBuilder>
implements VisitableBuilder<Subject, SubjectBuilder> {
    SubjectFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public SubjectBuilder() {
        this(true);
    }

    public SubjectBuilder(Boolean validationEnabled) {
        this(new Subject(), validationEnabled);
    }

    public SubjectBuilder(SubjectFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public SubjectBuilder(SubjectFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Subject(), validationEnabled);
    }

    public SubjectBuilder(SubjectFluent<?> fluent, Subject instance) {
        this(fluent, instance, true);
    }

    public SubjectBuilder(SubjectFluent<?> fluent, Subject instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public SubjectBuilder(Subject instance) {
        this(instance, (Boolean)true);
    }

    public SubjectBuilder(Subject instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validationEnabled = validationEnabled;
    }

    public SubjectBuilder(Validator validator) {
        this(new Subject(), (Boolean)true);
    }

    public SubjectBuilder(SubjectFluent<?> fluent, Subject instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiGroup(instance.getApiGroup());
        fluent.withKind(instance.getKind());
        fluent.withName(instance.getName());
        fluent.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public SubjectBuilder(Subject instance, Validator validator) {
        this.fluent = this;
        this.withApiGroup(instance.getApiGroup());
        this.withKind(instance.getKind());
        this.withName(instance.getName());
        this.withNamespace(instance.getNamespace());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public Subject build() {
        Subject buildable = new Subject(this.fluent.getApiGroup(), this.fluent.getKind(), this.fluent.getName(), this.fluent.getNamespace());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubjectBuilder that = (SubjectBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

