/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSource;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.GlusterfsVolumeSourceFluentImpl;
import javax.validation.Validator;

public class GlusterfsVolumeSourceBuilder
extends GlusterfsVolumeSourceFluentImpl<GlusterfsVolumeSourceBuilder>
implements VisitableBuilder<GlusterfsVolumeSource, GlusterfsVolumeSourceBuilder> {
    GlusterfsVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public GlusterfsVolumeSourceBuilder() {
        this(true);
    }

    public GlusterfsVolumeSourceBuilder(Boolean validationEnabled) {
        this(new GlusterfsVolumeSource(), validationEnabled);
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new GlusterfsVolumeSource(), validationEnabled);
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent, GlusterfsVolumeSource instance) {
        this(fluent, instance, true);
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent, GlusterfsVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withPath(instance.getPath());
        fluent.withReadOnly(instance.getReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSource instance) {
        this(instance, (Boolean)true);
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEndpoints(instance.getEndpoints());
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
        this.validationEnabled = validationEnabled;
    }

    public GlusterfsVolumeSourceBuilder(Validator validator) {
        this(new GlusterfsVolumeSource(), (Boolean)true);
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSourceFluent<?> fluent, GlusterfsVolumeSource instance, Validator validator) {
        this.fluent = fluent;
        fluent.withEndpoints(instance.getEndpoints());
        fluent.withPath(instance.getPath());
        fluent.withReadOnly(instance.getReadOnly());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public GlusterfsVolumeSourceBuilder(GlusterfsVolumeSource instance, Validator validator) {
        this.fluent = this;
        this.withEndpoints(instance.getEndpoints());
        this.withPath(instance.getPath());
        this.withReadOnly(instance.getReadOnly());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    @Override
    public GlusterfsVolumeSource build() {
        GlusterfsVolumeSource buildable = new GlusterfsVolumeSource(this.fluent.getEndpoints(), this.fluent.getPath(), this.fluent.isReadOnly());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate(buildable, this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GlusterfsVolumeSourceBuilder that = (GlusterfsVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

